/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.change.tracking.model.impl;

import com.liferay.change.tracking.model.CTCollectionTemplate;
import com.liferay.change.tracking.model.CTCollectionTemplateModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CTCollectionTemplate service. Represents a row in the &quot;CTCollectionTemplate&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CTCollectionTemplateModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CTCollectionTemplateImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTCollectionTemplateImpl
 * @generated
 */
@JSON(strict = true)
public class CTCollectionTemplateModelImpl
	extends BaseModelImpl<CTCollectionTemplate>
	implements CTCollectionTemplateModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ct collection template model instance should use the <code>CTCollectionTemplate</code> interface instead.
	 */
	public static final String TABLE_NAME = "CTCollectionTemplate";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionTemplateId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"name", Types.VARCHAR}, {"description", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionTemplateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CTCollectionTemplate (mvccVersion LONG default 0 not null,ctCollectionTemplateId LONG not null primary key,companyId LONG,userId LONG,createDate DATE null,modifiedDate DATE null,name VARCHAR(75) null,description VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP =
		"drop table CTCollectionTemplate";

	public static final String ORDER_BY_JPQL =
		" ORDER BY ctCollectionTemplate.createDate ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CTCollectionTemplate.createDate ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CTCollectionTemplateModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _ctCollectionTemplateId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCtCollectionTemplateId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _ctCollectionTemplateId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CTCollectionTemplate.class;
	}

	@Override
	public String getModelClassName() {
		return CTCollectionTemplate.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CTCollectionTemplate, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CTCollectionTemplate, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CTCollectionTemplate, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CTCollectionTemplate)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CTCollectionTemplate, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CTCollectionTemplate, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CTCollectionTemplate)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CTCollectionTemplate, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CTCollectionTemplate, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<CTCollectionTemplate, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<CTCollectionTemplate, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<CTCollectionTemplate, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", CTCollectionTemplate::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionTemplateId",
				CTCollectionTemplate::getCtCollectionTemplateId);
			attributeGetterFunctions.put(
				"companyId", CTCollectionTemplate::getCompanyId);
			attributeGetterFunctions.put(
				"userId", CTCollectionTemplate::getUserId);
			attributeGetterFunctions.put(
				"createDate", CTCollectionTemplate::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", CTCollectionTemplate::getModifiedDate);
			attributeGetterFunctions.put("name", CTCollectionTemplate::getName);
			attributeGetterFunctions.put(
				"description", CTCollectionTemplate::getDescription);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<CTCollectionTemplate, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<CTCollectionTemplate, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<CTCollectionTemplate, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<CTCollectionTemplate, Long>)
					CTCollectionTemplate::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionTemplateId",
				(BiConsumer<CTCollectionTemplate, Long>)
					CTCollectionTemplate::setCtCollectionTemplateId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<CTCollectionTemplate, Long>)
					CTCollectionTemplate::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<CTCollectionTemplate, Long>)
					CTCollectionTemplate::setUserId);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<CTCollectionTemplate, Date>)
					CTCollectionTemplate::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<CTCollectionTemplate, Date>)
					CTCollectionTemplate::setModifiedDate);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<CTCollectionTemplate, String>)
					CTCollectionTemplate::setName);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<CTCollectionTemplate, String>)
					CTCollectionTemplate::setDescription);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionTemplateId() {
		return _ctCollectionTemplateId;
	}

	@Override
	public void setCtCollectionTemplateId(long ctCollectionTemplateId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionTemplateId = ctCollectionTemplateId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CTCollectionTemplate.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CTCollectionTemplate toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CTCollectionTemplate>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CTCollectionTemplateImpl ctCollectionTemplateImpl =
			new CTCollectionTemplateImpl();

		ctCollectionTemplateImpl.setMvccVersion(getMvccVersion());
		ctCollectionTemplateImpl.setCtCollectionTemplateId(
			getCtCollectionTemplateId());
		ctCollectionTemplateImpl.setCompanyId(getCompanyId());
		ctCollectionTemplateImpl.setUserId(getUserId());
		ctCollectionTemplateImpl.setCreateDate(getCreateDate());
		ctCollectionTemplateImpl.setModifiedDate(getModifiedDate());
		ctCollectionTemplateImpl.setName(getName());
		ctCollectionTemplateImpl.setDescription(getDescription());

		ctCollectionTemplateImpl.resetOriginalValues();

		return ctCollectionTemplateImpl;
	}

	@Override
	public CTCollectionTemplate cloneWithOriginalValues() {
		CTCollectionTemplateImpl ctCollectionTemplateImpl =
			new CTCollectionTemplateImpl();

		ctCollectionTemplateImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		ctCollectionTemplateImpl.setCtCollectionTemplateId(
			this.<Long>getColumnOriginalValue("ctCollectionTemplateId"));
		ctCollectionTemplateImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		ctCollectionTemplateImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		ctCollectionTemplateImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		ctCollectionTemplateImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		ctCollectionTemplateImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		ctCollectionTemplateImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));

		return ctCollectionTemplateImpl;
	}

	@Override
	public int compareTo(CTCollectionTemplate ctCollectionTemplate) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), ctCollectionTemplate.getCreateDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CTCollectionTemplate)) {
			return false;
		}

		CTCollectionTemplate ctCollectionTemplate =
			(CTCollectionTemplate)object;

		long primaryKey = ctCollectionTemplate.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CTCollectionTemplate> toCacheModel() {
		CTCollectionTemplateCacheModel ctCollectionTemplateCacheModel =
			new CTCollectionTemplateCacheModel();

		ctCollectionTemplateCacheModel.mvccVersion = getMvccVersion();

		ctCollectionTemplateCacheModel.ctCollectionTemplateId =
			getCtCollectionTemplateId();

		ctCollectionTemplateCacheModel.companyId = getCompanyId();

		ctCollectionTemplateCacheModel.userId = getUserId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			ctCollectionTemplateCacheModel.createDate = createDate.getTime();
		}
		else {
			ctCollectionTemplateCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			ctCollectionTemplateCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			ctCollectionTemplateCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		ctCollectionTemplateCacheModel.name = getName();

		String name = ctCollectionTemplateCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			ctCollectionTemplateCacheModel.name = null;
		}

		ctCollectionTemplateCacheModel.description = getDescription();

		String description = ctCollectionTemplateCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			ctCollectionTemplateCacheModel.description = null;
		}

		return ctCollectionTemplateCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CTCollectionTemplate, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CTCollectionTemplate, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CTCollectionTemplate, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CTCollectionTemplate)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CTCollectionTemplate>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CTCollectionTemplate.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionTemplateId;
	private long _companyId;
	private long _userId;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _name;
	private String _description;

	public <T> T getColumnValue(String columnName) {
		Function<CTCollectionTemplate, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CTCollectionTemplate)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"ctCollectionTemplateId", _ctCollectionTemplateId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("description", _description);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionTemplateId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("createDate", 16L);

		columnBitmasks.put("modifiedDate", 32L);

		columnBitmasks.put("name", 64L);

		columnBitmasks.put("description", 128L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CTCollectionTemplate _escapedModel;

}