/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.model.CTProcessTable;
import com.liferay.change.tracking.service.base.CTProcessServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.LimitStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.query.sort.OrderByInfo;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.background.task.model.BackgroundTaskTable;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.permission.PortletPermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ct", "json.web.service.context.path=CTProcess"}, service={AopService.class})
public class CTProcessServiceImpl
extends CTProcessServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private PortletPermission _portletPermission;

    public List<CTProcess> getCTProcesses(long companyId, long userId, String keywords, int status, int type, int start, int end, OrderByComparator<CTProcess> orderByComparator) throws PortalException {
        this._portletPermission.check(this.getPermissionChecker(), "com_liferay_change_tracking_web_portlet_PublicationsPortlet", "VIEW");
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Table)CTProcessTable.INSTANCE).from((Table)CTProcessTable.INSTANCE).innerJoinON((Table)CTCollectionTable.INSTANCE, CTCollectionTable.INSTANCE.ctCollectionId.eq((Expression)CTProcessTable.INSTANCE.ctCollectionId)).innerJoinON((Table)BackgroundTaskTable.INSTANCE, BackgroundTaskTable.INSTANCE.backgroundTaskId.eq((Expression)CTProcessTable.INSTANCE.backgroundTaskId)).where(this._getPredicate(companyId, keywords, status, type, userId)).orderBy(orderByStep -> {
            if (orderByComparator != null) {
                LimitStep limitStep = orderByStep.orderBy((Table)CTProcessTable.INSTANCE, (OrderByInfo)orderByComparator);
                if (limitStep == orderByStep) {
                    return orderByStep.orderBy((Table)CTCollectionTable.INSTANCE, (OrderByInfo)orderByComparator);
                }
                return limitStep;
            }
            return orderByStep.orderBy(new OrderByExpression[]{CTProcessTable.INSTANCE.createDate.descending()});
        }).limit(start, end);
        return (List)this.ctProcessPersistence.dslQuery(dslQuery);
    }

    public List<CTProcess> getCTProcesses(long companyId, long userId, String keywords, int status, int start, int end, OrderByComparator<CTProcess> orderByComparator) throws PortalException {
        return this.getCTProcesses(companyId, userId, keywords, status, 0, start, end, orderByComparator);
    }

    public int getCTProcessesCount(long companyId, long userId, String keywords, int status) {
        return this.getCTProcessesCount(companyId, userId, keywords, status, 0);
    }

    public int getCTProcessesCount(long companyId, long userId, String keywords, int status, int type) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.count().from((Table)CTProcessTable.INSTANCE).innerJoinON((Table)CTCollectionTable.INSTANCE, CTCollectionTable.INSTANCE.ctCollectionId.eq((Expression)CTProcessTable.INSTANCE.ctCollectionId)).innerJoinON((Table)BackgroundTaskTable.INSTANCE, BackgroundTaskTable.INSTANCE.backgroundTaskId.eq((Expression)CTProcessTable.INSTANCE.backgroundTaskId)).where(this._getPredicate(companyId, keywords, status, type, userId));
        return this.ctProcessPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    private Predicate _getPredicate(long companyId, String keywords, int status, int type, long userId) {
        Predicate predicate = CTProcessTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
            if (status != -1) {
                return BackgroundTaskTable.INSTANCE.status.eq((Object)status);
            }
            return null;
        }).and(() -> {
            if (type > -1) {
                return CTProcessTable.INSTANCE.type.eq((Object)type);
            }
            return null;
        }).and(() -> {
            if (userId > 0L) {
                return CTProcessTable.INSTANCE.userId.eq((Object)userId);
            }
            return null;
        });
        Predicate keywordsPredicate = null;
        for (String keyword : this._customSQL.keywords(keywords, true, WildcardMode.SURROUND)) {
            if (keyword == null) continue;
            Predicate keywordPredicate = DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.name).like(keyword).or((Expression)DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.description).like(keyword));
            keywordsPredicate = keywordsPredicate == null ? keywordPredicate : keywordsPredicate.or((Expression)keywordPredicate);
        }
        if (keywordsPredicate == null) {
            return predicate;
        }
        return predicate.and((Expression)keywordsPredicate.withParentheses());
    }
}

