/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.closure.CTClosure;
import com.liferay.change.tracking.closure.CTClosureFactory;
import com.liferay.change.tracking.conflict.CTEntryConflictHelper;
import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.exception.CTCollectionDescriptionException;
import com.liferay.change.tracking.exception.CTCollectionNameException;
import com.liferay.change.tracking.exception.CTEnclosureException;
import com.liferay.change.tracking.exception.CTLocalizedException;
import com.liferay.change.tracking.internal.CTEnclosureUtil;
import com.liferay.change.tracking.internal.CTServiceCopier;
import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.internal.closure.Node;
import com.liferay.change.tracking.internal.conflict.CTConflictChecker;
import com.liferay.change.tracking.internal.conflict.ConstraintResolverConflictInfo;
import com.liferay.change.tracking.internal.conflict.ModificationConflictInfo;
import com.liferay.change.tracking.internal.helper.CTTableMapperHelper;
import com.liferay.change.tracking.internal.reference.TableReferenceDefinitionManager;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverKey;
import com.liferay.change.tracking.mapping.CTMappingTableInfo;
import com.liferay.change.tracking.model.CTAutoResolutionInfo;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTEntryTable;
import com.liferay.change.tracking.model.CTPreferences;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.model.CTSchemaVersion;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.change.tracking.service.CTProcessLocalService;
import com.liferay.change.tracking.service.CTSchemaVersionLocalService;
import com.liferay.change.tracking.service.base.CTCollectionLocalServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTAutoResolutionInfoPersistence;
import com.liferay.change.tracking.service.persistence.CTCommentPersistence;
import com.liferay.change.tracking.service.persistence.CTEntryPersistence;
import com.liferay.change.tracking.service.persistence.CTMessagePersistence;
import com.liferay.change.tracking.service.persistence.CTPreferencesPersistence;
import com.liferay.change.tracking.service.persistence.CTProcessPersistence;
import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.model.uid.UIDFactory;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTCollection"}, service={AopService.class})
public class CTCollectionLocalServiceImpl
extends CTCollectionLocalServiceBaseImpl {
    private static final int[] _STATUSES = new int[]{0, 2, 3, 8, 7};
    private static final Log _log = LogFactoryUtil.getLog(CTCollectionLocalServiceImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver<?>> _constraintResolverServiceTrackerMap;
    @Reference
    private CTAutoResolutionInfoPersistence _ctAutoResolutionInfoPersistence;
    @Reference
    private CTClosureFactory _ctClosureFactory;
    @Reference
    private CTCommentPersistence _ctCommentPersistence;
    private ServiceTrackerMap<String, CTDisplayRenderer<?>> _ctDisplayRendererServiceTrackerMap;
    private ServiceTrackerMap<String, CTEntryConflictHelper> _ctEntryConflictHelperServiceTrackerMap;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTEntryPersistence _ctEntryPersistence;
    @Reference
    private CTMessagePersistence _ctMessagePersistence;
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;
    @Reference
    private CTPreferencesPersistence _ctPreferencesPersistence;
    @Reference
    private CTProcessLocalService _ctProcessLocalService;
    @Reference
    private CTProcessPersistence _ctProcessPersistence;
    @Reference
    private CTSchemaVersionLocalService _ctSchemaVersionLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private TableReferenceDefinitionManager _tableReferenceDefinitionManager;
    @Reference
    private UIDFactory _uidFactory;

    @Indexable(type=IndexableType.REINDEX)
    public CTCollection addCTCollection(long companyId, long userId, String name, String description) throws PortalException {
        this._validate(name, description);
        long ctCollectionId = this.counterLocalService.increment(CTCollection.class.getName());
        CTCollection ctCollection = this.ctCollectionPersistence.create(ctCollectionId);
        ctCollection.setCompanyId(companyId);
        ctCollection.setUserId(userId);
        CTSchemaVersion latestCTSchemaVersion = this._ctSchemaVersionLocalService.getLatestCTSchemaVersion(companyId);
        ctCollection.setSchemaVersionId(latestCTSchemaVersion.getSchemaVersionId());
        ctCollection.setName(name);
        ctCollection.setDescription(description);
        ctCollection.setStatus(2);
        ctCollection = (CTCollection)this.ctCollectionPersistence.update((BaseModel)ctCollection);
        this._resourceLocalService.addResources(ctCollection.getCompanyId(), 0L, ctCollection.getUserId(), CTCollection.class.getName(), ctCollection.getCtCollectionId(), false, false, false);
        return ctCollection;
    }

    public Map<Long, List<ConflictInfo>> checkConflicts(CTCollection ctCollection) throws PortalException {
        List ctEntries = this._ctEntryPersistence.findByCtCollectionId(ctCollection.getCtCollectionId());
        return this.checkConflicts(ctCollection.getCompanyId(), ctEntries, ctCollection.getCtCollectionId(), ctCollection.getName(), 0L, "Production");
    }

    public Map<Long, List<ConflictInfo>> checkConflicts(long companyId, List<CTEntry> ctEntries, long fromCTCollectionId, String fromCTCollectionName, long toCTCollectionId, String toCTCollectionName) throws PortalException {
        HashMap<Long, List<ConflictInfo>> conflictInfoMap = new HashMap<Long, List<ConflictInfo>>();
        HashMap<Long, CTConflictChecker> ctConflictCheckers = new HashMap<Long, CTConflictChecker>();
        for (CTEntry ctEntry : ctEntries) {
            CTConflictChecker cTConflictChecker = ctConflictCheckers.computeIfAbsent(ctEntry.getModelClassNameId(), modelClassNameId -> {
                CTService<?> ctService = this._ctServiceRegistry.getCTService((long)modelClassNameId);
                if (ctService == null) {
                    throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to check conflicts for ", fromCTCollectionName, " to ", toCTCollectionName, " because service for ", modelClassNameId, " is missing"}));
                }
                return new CTConflictChecker(this._classNameLocalService, this._constraintResolverServiceTrackerMap, this._ctDisplayRendererServiceTrackerMap, this._ctEntryConflictHelperServiceTrackerMap, this._ctEntryLocalService, ctService, (long)modelClassNameId, fromCTCollectionId, this._tableReferenceDefinitionManager, toCTCollectionId);
            });
            cTConflictChecker.addCTEntry(ctEntry);
        }
        SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)fromCTCollectionId);
        Iterator iterator = null;
        try {
            for (Map.Entry entry : ctConflictCheckers.entrySet()) {
                CTConflictChecker ctConflictChecker = (CTConflictChecker)entry.getValue();
                List<ConflictInfo> conflictInfos = ctConflictChecker.check();
                if (conflictInfos.isEmpty()) continue;
                conflictInfoMap.put((Long)entry.getKey(), conflictInfos);
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (safeCloseable != null) {
                if (iterator != null) {
                    try {
                        safeCloseable.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    safeCloseable.close();
                }
            }
        }
        if (toCTCollectionId != 0L) {
            return conflictInfoMap;
        }
        List ctAutoResolutionInfos = this._ctAutoResolutionInfoPersistence.findByCtCollectionId(fromCTCollectionId);
        for (Map.Entry entry : conflictInfoMap.entrySet()) {
            for (ConflictInfo conflictInfo : (List)entry.getValue()) {
                if (!conflictInfo.isResolved()) continue;
                CTAutoResolutionInfo ctAutoResolutionInfo = this._ctAutoResolutionInfoPersistence.create(this.counterLocalService.increment(CTAutoResolutionInfo.class.getName()));
                ctAutoResolutionInfo.setCompanyId(companyId);
                ctAutoResolutionInfo.setCreateDate(new Date());
                ctAutoResolutionInfo.setCtCollectionId(fromCTCollectionId);
                ctAutoResolutionInfo.setModelClassNameId(((Long)entry.getKey()).longValue());
                ctAutoResolutionInfo.setSourceModelClassPK(conflictInfo.getSourcePrimaryKey());
                ctAutoResolutionInfo.setTargetModelClassPK(conflictInfo.getTargetPrimaryKey());
                if (conflictInfo instanceof ConstraintResolverConflictInfo) {
                    ConstraintResolverConflictInfo constraintResolverConflictInfo = (ConstraintResolverConflictInfo)conflictInfo;
                    ConstraintResolver<?> constraintResolver = constraintResolverConflictInfo.getConstraintResolver();
                    ctAutoResolutionInfo.setConflictIdentifier(StringUtil.merge((String[])constraintResolver.getUniqueIndexColumnNames(), (String)","));
                    constraintResolverConflictInfo.setCtAutoResolutionInfoId(ctAutoResolutionInfo.getCtAutoResolutionInfoId());
                } else if (conflictInfo instanceof ModificationConflictInfo) {
                    ModificationConflictInfo resolvedModificationConflictInfo = (ModificationConflictInfo)conflictInfo;
                    resolvedModificationConflictInfo.setCtAutoResolutionInfoId(ctAutoResolutionInfo.getCtAutoResolutionInfoId());
                    ctAutoResolutionInfo.setConflictIdentifier(ModificationConflictInfo.class.getName());
                }
                this._ctAutoResolutionInfoPersistence.update((BaseModel)ctAutoResolutionInfo);
            }
        }
        for (CTAutoResolutionInfo cTAutoResolutionInfo : ctAutoResolutionInfos) {
            List conflictInfos = conflictInfoMap.computeIfAbsent(cTAutoResolutionInfo.getModelClassNameId(), key -> new ArrayList());
            if (Objects.equals(cTAutoResolutionInfo.getConflictIdentifier(), ModificationConflictInfo.class.getName())) {
                ModificationConflictInfo resolvedModificationConflictInfo = new ModificationConflictInfo(cTAutoResolutionInfo.getSourceModelClassPK(), true);
                resolvedModificationConflictInfo.setCtAutoResolutionInfoId(cTAutoResolutionInfo.getCtAutoResolutionInfoId());
                conflictInfos.add(resolvedModificationConflictInfo);
                continue;
            }
            List uniqueIndexes = StringUtil.split((String)cTAutoResolutionInfo.getConflictIdentifier(), (char)',');
            ClassName className = this._classNameLocalService.getClassName(cTAutoResolutionInfo.getModelClassNameId());
            ConstraintResolver constraintResolver = (ConstraintResolver)this._constraintResolverServiceTrackerMap.getService((Object)new ConstraintResolverKey(className.getValue(), uniqueIndexes.toArray(new String[0])));
            if (constraintResolver == null) continue;
            ConstraintResolverConflictInfo constraintResolverConflictInfo = new ConstraintResolverConflictInfo(constraintResolver, true, cTAutoResolutionInfo.getSourceModelClassPK(), cTAutoResolutionInfo.getTargetModelClassPK());
            constraintResolverConflictInfo.setCtAutoResolutionInfoId(cTAutoResolutionInfo.getCtAutoResolutionInfoId());
            conflictInfos.add(constraintResolverConflictInfo);
        }
        return conflictInfoMap;
    }

    public Map<Long, List<ConflictInfo>> checkConflicts(long companyId, long[] ctEntryIds, long fromCTCollectionId, String fromCTCollectionName, long toCTCollectionId, String toCTCollectionName) throws PortalException {
        List<CTEntry> ctEntries = this.getRelatedCTEntries(fromCTCollectionId, ctEntryIds);
        return this.checkConflicts(companyId, ctEntries, fromCTCollectionId, fromCTCollectionName, toCTCollectionId, toCTCollectionName);
    }

    public void deleteCompanyCTCollections(long companyId) throws PortalException {
        List ctCollections = this.ctCollectionPersistence.findByCompanyId(companyId);
        for (CTCollection ctCollection : ctCollections) {
            this.deleteCTCollection(ctCollection);
        }
    }

    public void deleteCTAutoResolutionInfo(long ctAutoResolutionInfoId) {
        CTAutoResolutionInfo ctAutoResolutionInfo = this._ctAutoResolutionInfoPersistence.fetchByPrimaryKey(ctAutoResolutionInfoId);
        if (ctAutoResolutionInfo != null) {
            this._ctAutoResolutionInfoPersistence.remove((BaseModel)ctAutoResolutionInfo);
        }
    }

    @Override
    public CTCollection deleteCTCollection(CTCollection ctCollection) throws PortalException {
        CTSchemaVersion ctSchemaVersion;
        this._ctServiceRegistry.onBeforeRemove(ctCollection.getCtCollectionId());
        try {
            for (CTTableMapperHelper ctTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
                ctTableMapperHelper.delete(ctCollection.getCtCollectionId());
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        List ctEntries = this._ctEntryPersistence.findByCtCollectionId(ctCollection.getCtCollectionId());
        HashSet<Long> modelClassNameIds = new HashSet<Long>();
        for (CTEntry ctEntry : ctEntries) {
            modelClassNameIds.add(ctEntry.getModelClassNameId());
        }
        Iterator iterator = modelClassNameIds.iterator();
        while (iterator.hasNext()) {
            long modelClassNameId = (Long)iterator.next();
            CTService<?> ctService = this._ctServiceRegistry.getCTService(modelClassNameId);
            if (ctService == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No CTService found for classNameId " + modelClassNameId));
                continue;
            }
            ctService.updateWithUnsafeFunction(ctPersistence -> {
                Connection connection = this._currentConnection.getConnection(ctPersistence.getDataSource());
                try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"delete from ", ctPersistence.getTableName(), " where ctCollectionId = ", ctCollection.getCtCollectionId()}));){
                    Integer n = preparedStatement.executeUpdate();
                    return n;
                }
                catch (Exception exception) {
                    throw new SystemException((Throwable)exception);
                }
            });
        }
        this._ctAutoResolutionInfoPersistence.removeByCtCollectionId(ctCollection.getCtCollectionId());
        this._ctCommentPersistence.removeByCtCollectionId(ctCollection.getCtCollectionId());
        for (CTEntry ctEntry : ctEntries) {
            this._ctEntryPersistence.remove((BaseModel)ctEntry);
        }
        this._ctMessagePersistence.removeByCtCollectionId(ctCollection.getCtCollectionId());
        List ctProcesses = this._ctProcessPersistence.findByCtCollectionId(ctCollection.getCtCollectionId());
        for (CTProcess ctProcess : ctProcesses) {
            this._ctProcessLocalService.deleteCTProcess(ctProcess);
        }
        Group group = this._groupLocalService.fetchGroup(ctCollection.getCompanyId(), this._classNameLocalService.getClassNameId(CTCollection.class), ctCollection.getCtCollectionId());
        if (group != null) {
            this._groupLocalService.deleteGroup(group);
        }
        this._resourceLocalService.deleteResource(ctCollection.getCompanyId(), CTCollection.class.getName(), 4, ctCollection.getCtCollectionId());
        int count = this.ctCollectionPersistence.countBySchemaVersionId(ctCollection.getSchemaVersionId());
        if (count == 1 && (ctSchemaVersion = this._ctSchemaVersionLocalService.fetchCTSchemaVersion(ctCollection.getSchemaVersionId())) != null && !this._ctSchemaVersionLocalService.isLatestCTSchemaVersion(ctSchemaVersion, true)) {
            this._ctSchemaVersionLocalService.deleteCTSchemaVersion(ctSchemaVersion);
        }
        return (CTCollection)this.ctCollectionPersistence.remove((BaseModel)ctCollection);
    }

    public void discardCTEntry(long ctCollectionId, long modelClassNameId, long modelClassPK, boolean force) throws PortalException {
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        if (!force && ctCollection.getStatus() != 2 && ctCollection.getStatus() != 1) {
            throw new PortalException("Change tracking collection " + ctCollection + " is read only");
        }
        Map<Long, List<CTEntry>> discardCTEntries = this._getDiscardCTEntries(ctCollection, modelClassNameId, modelClassPK);
        for (Map.Entry<Long, List<CTEntry>> entry : discardCTEntries.entrySet()) {
            this._discardCTEntries(ctCollection, entry.getKey(), entry.getValue());
        }
    }

    public List<CTCollection> getCTCollections(long companyId, int status, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        if (status == -1) {
            return this.ctCollectionPersistence.findByCompanyId(companyId, start, end, orderByComparator);
        }
        return this.ctCollectionPersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public List<CTMappingTableInfo> getCTMappingTableInfos(long ctCollectionId) {
        ArrayList<CTMappingTableInfo> ctMappingTableInfos = new ArrayList<CTMappingTableInfo>();
        for (CTTableMapperHelper ctTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
            CTMappingTableInfo ctMappingTableInfo = ctTableMapperHelper.getCTMappingTableInfo(ctCollectionId);
            if (ctMappingTableInfo == null) continue;
            ctMappingTableInfos.add(ctMappingTableInfo);
        }
        return ctMappingTableInfos;
    }

    public Map<Long, List<CTEntry>> getDiscardCTEntries(long ctCollectionId, long modelClassNameId, long modelClassPK) throws PortalException {
        return this._getDiscardCTEntries(this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId), modelClassNameId, modelClassPK);
    }

    public List<CTCollection> getExclusivePublishedCTCollections(long modelClassNameId, long modelClassPK) throws PortalException {
        return (List)this.ctCollectionPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CTCollectionTable.INSTANCE).from((Table)CTCollectionTable.INSTANCE).innerJoinON((Table)CTEntryTable.INSTANCE, CTEntryTable.INSTANCE.ctCollectionId.eq((Expression)CTCollectionTable.INSTANCE.ctCollectionId).and((Expression)CTEntryTable.INSTANCE.modelClassNameId.eq((Object)modelClassNameId).and((Expression)CTEntryTable.INSTANCE.modelClassPK.eq((Object)modelClassPK)))).where(CTCollectionTable.INSTANCE.ctCollectionId.neq((Object)CTCollectionThreadLocal.getCTCollectionId()).and((Expression)CTCollectionTable.INSTANCE.status.neq((Object)3))).orderBy(new OrderByExpression[]{CTCollectionTable.INSTANCE.status.descending(), CTCollectionTable.INSTANCE.statusDate.descending()}));
    }

    public List<CTEntry> getRelatedCTEntries(long ctCollectionId, long[] ctEntryIds) {
        Object[] ctEntryIdLongs = new Long[ctEntryIds.length];
        for (int i = 0; i < ctEntryIds.length; ++i) {
            ctEntryIdLongs[i] = ctEntryIds[i];
        }
        ArrayList<CTEntry> ctEntries = (ArrayList<CTEntry>)this._ctEntryLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CTEntryTable.INSTANCE).from((Table)CTEntryTable.INSTANCE).where(CTEntryTable.INSTANCE.ctCollectionId.eq((Object)ctCollectionId).and((Expression)CTEntryTable.INSTANCE.ctEntryId.in(ctEntryIdLongs))));
        HashSet<CTEntry> ctEntrySet = new HashSet<CTEntry>();
        for (CTEntry ctEntry : ctEntries) {
            ctEntrySet.addAll(this._getRelatedCTEntries(ctEntry.getCtCollectionId(), ctEntry.getModelClassNameId(), ctEntry.getModelClassPK()));
        }
        ctEntries = new ArrayList<CTEntry>();
        ctEntries.addAll(ctEntrySet);
        return ctEntries;
    }

    public boolean hasUnapprovedChanges(long ctCollectionId) throws SQLException {
        HashMap<Long, CTPersistence> ctPersistences = new HashMap<Long, CTPersistence>();
        HashSet<Long> modelClassNameIds = new HashSet<Long>();
        for (CTEntry cTEntry : this._ctEntryLocalService.getCTCollectionCTEntries(ctCollectionId)) {
            long modelClassNameId = cTEntry.getModelClassNameId();
            if (ctPersistences.containsKey(modelClassNameId) || modelClassNameIds.contains(modelClassNameId)) continue;
            CTService<?> ctService = this._ctServiceRegistry.getCTService(modelClassNameId);
            if (ctService == null) {
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to check for unapproved changes for change ", "tracking collection ", ctCollectionId, " because the service for ", modelClassNameId, " is missing"}));
            }
            CTPersistence ctPersistence = ctService.getCTPersistence();
            Map tableColumnsMap = ctPersistence.getTableColumnsMap();
            if (tableColumnsMap.containsKey("status") && tableColumnsMap.containsKey("statusByUserId")) {
                ctPersistences.putIfAbsent(modelClassNameId, ctService.getCTPersistence());
                continue;
            }
            modelClassNameIds.add(modelClassNameId);
        }
        for (Map.Entry entry : ctPersistences.entrySet()) {
            CTPersistence ctPersistence = (CTPersistence)entry.getValue();
            DataSource dataSource = ctPersistence.getDataSource();
            Connection connection = dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select count(*) from ", ctPersistence.getTableName(), " where ctCollectionId = ", ctCollectionId, " and status not in (", StringUtil.merge((int[])_STATUSES, (String)","), ")"}));
            Throwable throwable = null;
            try {
                ResultSet resultSet = preparedStatement.executeQuery();
                Throwable throwable2 = null;
                try {
                    int count;
                    if (!resultSet.next() || (count = resultSet.getInt(1)) <= 0) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    resultSet.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (preparedStatement == null) continue;
                if (throwable != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                preparedStatement.close();
            }
        }
        return false;
    }

    public boolean isCTEntryEnclosed(long ctCollectionId, long modelClassNameId, long modelClassPK) {
        CTClosure ctClosure = this._ctClosureFactory.create(ctCollectionId);
        Map<Long, Set<Long>> enclosureMap = CTEnclosureUtil.getEnclosureMap(ctClosure, modelClassNameId, modelClassPK);
        for (Map.Entry<Long, Long> entry : CTEnclosureUtil.getEnclosureParentEntries(ctClosure, enclosureMap)) {
            int count = this._ctEntryPersistence.countByC_MCNI_MCPK(ctCollectionId, entry.getKey().longValue(), entry.getValue().longValue());
            if (count <= 0) continue;
            return false;
        }
        return true;
    }

    public CTCollection undoCTCollection(long ctCollectionId, long userId, String name, String description) throws PortalException {
        CTCollection undoCTCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        if (undoCTCollection.getStatus() != 0) {
            throw new CTLocalizedException(StringBundler.concat((String[])new String[]{"Unable to undo ", undoCTCollection.getName(), " because it is not published"}), "unable-to-revert-x-because-it-is-not-published", new Serializable[]{undoCTCollection.getName()});
        }
        if (!this._ctSchemaVersionLocalService.isLatestCTSchemaVersion(undoCTCollection.getSchemaVersionId())) {
            throw new CTLocalizedException(StringBundler.concat((String[])new String[]{"Unable to undo ", undoCTCollection.getName(), " because it is out of date with the current release"}), "unable-to-revert-x-because-it-is-out-of-date-with-the-current-release", new Serializable[]{undoCTCollection.getName()});
        }
        CTCollection newCTCollection = this.addCTCollection(undoCTCollection.getCompanyId(), userId, name, description);
        CTPreferences ctPreferences = this._ctPreferencesLocalService.getCTPreferences(undoCTCollection.getCompanyId(), userId);
        ctPreferences.setCtCollectionId(newCTCollection.getCtCollectionId());
        ctPreferences.setPreviousCtCollectionId(0L);
        this._ctPreferencesPersistence.update((BaseModel)ctPreferences);
        List publishedCTEntries = this._ctEntryPersistence.findByCtCollectionId(undoCTCollection.getCtCollectionId());
        HashMap ctServiceCopiers = new HashMap();
        long batchCounter = this.counterLocalService.increment(CTEntry.class.getName(), publishedCTEntries.size());
        batchCounter -= (long)publishedCTEntries.size();
        for (CTEntry publishedCTEntry : publishedCTEntries) {
            long modelClassNameId = publishedCTEntry.getModelClassNameId();
            if (!ctServiceCopiers.containsKey(modelClassNameId)) {
                CTService<?> ctService = this._ctServiceRegistry.getCTService(modelClassNameId);
                if (ctService == null) {
                    throw new CTLocalizedException(StringBundler.concat((Object[])new Object[]{"Unable to undo ", undoCTCollection.getName(), " because service for ", modelClassNameId, " is missing"}), "unable-to-revert-x-because-service-for-x-is-missing", new Serializable[]{undoCTCollection.getName(), Long.valueOf(publishedCTEntry.getModelClassNameId())});
                }
                ctServiceCopiers.put(modelClassNameId, new CTServiceCopier(ctService, undoCTCollection.getCtCollectionId(), newCTCollection.getCtCollectionId()));
            }
            CTEntry ctEntry = this._ctEntryPersistence.create(++batchCounter);
            ctEntry.setCompanyId(newCTCollection.getCompanyId());
            ctEntry.setUserId(newCTCollection.getUserId());
            ctEntry.setCtCollectionId(newCTCollection.getCtCollectionId());
            ctEntry.setModelClassNameId(modelClassNameId);
            ctEntry.setModelClassPK(publishedCTEntry.getModelClassPK());
            ctEntry.setModelMvccVersion(publishedCTEntry.getModelMvccVersion());
            int changeType = publishedCTEntry.getChangeType();
            if (changeType == 0) {
                changeType = 1;
            } else if (changeType == 1) {
                changeType = 0;
            }
            ctEntry.setChangeType(changeType);
            this._ctEntryPersistence.update((BaseModel)ctEntry);
        }
        try {
            for (CTServiceCopier ctServiceCopier : ctServiceCopiers.values()) {
                ctServiceCopier.copy();
            }
            for (CTTableMapperHelper ctTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
                ctTableMapperHelper.undo(undoCTCollection.getCtCollectionId(), newCTCollection.getCtCollectionId());
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        this._ctServiceRegistry.onAfterCopy(undoCTCollection, newCTCollection);
        return newCTCollection;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CTCollection updateCTCollection(long userId, long ctCollectionId, String name, String description) throws PortalException {
        this._validate(name, description);
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        Date modifiedDate = new Date();
        ctCollection.setModifiedDate(modifiedDate);
        ctCollection.setName(name);
        ctCollection.setDescription(description);
        ctCollection.setStatusByUserId(userId);
        ctCollection.setStatusDate(modifiedDate);
        return (CTCollection)this.ctCollectionPersistence.update((BaseModel)ctCollection);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._constraintResolverServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ConstraintResolver.class, null, (serviceReference, emitter) -> {
            ConstraintResolver constraintResolver = (ConstraintResolver)bundleContext.getService(serviceReference);
            emitter.emit((Object)new ConstraintResolverKey(constraintResolver.getModelClass(), constraintResolver.getUniqueIndexColumnNames()));
        });
        this._ctDisplayRendererServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CTDisplayRenderer.class, null, (serviceReference, emitter) -> {
            CTDisplayRenderer ctDisplayRenderer = (CTDisplayRenderer)bundleContext.getService(serviceReference);
            Class modelClass = ctDisplayRenderer.getModelClass();
            emitter.emit((Object)modelClass.getName());
        });
        this._ctEntryConflictHelperServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CTEntryConflictHelper.class, null, (serviceReference, emitter) -> {
            CTEntryConflictHelper ctEntryConflictHelper = (CTEntryConflictHelper)bundleContext.getService(serviceReference);
            Class modelClass = ctEntryConflictHelper.getModelClass();
            emitter.emit((Object)modelClass.getName());
        });
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        this._constraintResolverServiceTrackerMap.close();
        this._ctDisplayRendererServiceTrackerMap.close();
        this._ctEntryConflictHelperServiceTrackerMap.close();
    }

    private void _discardCTEntries(CTCollection ctCollection, long classNameId, List<CTEntry> ctEntries) {
        CTService<?> ctService = this._ctServiceRegistry.getCTService(classNameId);
        ctService.updateWithUnsafeFunction(ctPersistence -> {
            Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
            if (primaryKeyNames.size() != 1) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", ctPersistence.getTableName(), "}"}));
            }
            Iterator iterator = primaryKeyNames.iterator();
            String primaryKeyName = (String)iterator.next();
            StringBundler sb = new StringBundler(2 * ctEntries.size() + 7);
            sb.append("delete from ");
            sb.append(ctPersistence.getTableName());
            sb.append(" where ctCollectionId = ");
            sb.append(ctCollection.getCtCollectionId());
            sb.append(" and ");
            sb.append(primaryKeyName);
            sb.append(" in (");
            for (CTEntry ctEntry : ctEntries) {
                sb.append(ctEntry.getModelClassPK());
                sb.append(", ");
            }
            sb.setStringAt(")", sb.index() - 1);
            Connection connection = this._currentConnection.getConnection(ctPersistence.getDataSource());
            try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());){
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            for (String mappingTableName : ctPersistence.getMappingTableNames()) {
                sb.setStringAt(mappingTableName, 1);
                try {
                    PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
                    Throwable throwable = null;
                    try {
                        preparedStatement.executeUpdate();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (preparedStatement == null) continue;
                        if (throwable != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    throw new SystemException((Throwable)exception);
                }
            }
            return null;
        });
        ArrayList<Long> modelClassPKs = new ArrayList<Long>(ctEntries.size());
        for (CTEntry ctEntry : ctEntries) {
            modelClassPKs.add(ctEntry.getModelClassPK());
            this._ctEntryPersistence.remove((BaseModel)ctEntry);
        }
        for (CTAutoResolutionInfo ctAutoResolutionInfo : this._ctAutoResolutionInfoPersistence.findByC_MCNI_SMCPK(ctCollection.getCtCollectionId(), classNameId, ArrayUtil.toLongArray(modelClassPKs))) {
            this._ctAutoResolutionInfoPersistence.remove((BaseModel)ctAutoResolutionInfo);
        }
        Indexer indexer = this._indexerRegistry.getIndexer(ctService.getModelClass());
        if (indexer != null) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                ArrayList<String> uids = new ArrayList<String>(ctEntries.size());
                for (CTEntry ctEntry : ctEntries) {
                    if (ctEntry.getChangeType() == 1) continue;
                    uids.add(this._uidFactory.getUID(indexer.getClassName(), (Serializable)Long.valueOf(ctEntry.getModelClassPK()), ctEntry.getCtCollectionId()));
                }
                this._indexWriterHelper.deleteDocuments(ctCollection.getCompanyId(), uids, indexer.isCommitImmediately());
                return null;
            });
        }
    }

    private Map<Long, List<CTEntry>> _getDiscardCTEntries(CTCollection ctCollection, long modelClassNameId, long modelClassPK) throws PortalException {
        int count = this._ctEntryPersistence.countByC_MCNI_MCPK(ctCollection.getCtCollectionId(), modelClassNameId, modelClassPK);
        if (count == 0) {
            throw new CTEnclosureException(StringBundler.concat((Object[])new Object[]{"Unable to find CTEntry for {classNameId=", modelClassNameId, ", classPK=", modelClassPK, ", ctCollectionId=", ctCollection.getCtCollectionId(), "}"}));
        }
        CTClosure ctClosure = this._ctClosureFactory.create(ctCollection.getCtCollectionId(), modelClassNameId);
        Map<Long, Set<Long>> enclosureMap = CTEnclosureUtil.getEnclosureMap(ctClosure, modelClassNameId, modelClassPK);
        HashMap<Long, List<CTEntry>> discardCTEntries = new HashMap<Long, List<CTEntry>>();
        for (Map.Entry<Long, Set<Long>> enclosureEntry : enclosureMap.entrySet()) {
            long classNameId = enclosureEntry.getKey();
            Set<Long> classPKs = enclosureEntry.getValue();
            ArrayList<CTEntry> ctEntries = new ArrayList<CTEntry>(classPKs.size());
            for (long classPK : classPKs) {
                CTEntry ctEntry = this._ctEntryPersistence.fetchByC_MCNI_MCPK(ctCollection.getCtCollectionId(), classNameId, classPK);
                if (ctEntry == null) continue;
                ctEntries.add(ctEntry);
            }
            if (ctEntries.isEmpty()) continue;
            discardCTEntries.put(classNameId, ctEntries);
        }
        return discardCTEntries;
    }

    private List<CTEntry> _getRelatedCTEntries(long ctCollectionId, long modelClassNameId, long modelClassPK) {
        long classPK2;
        Iterator<Object> iterator;
        CTClosure ctClosure = this._ctClosureFactory.create(ctCollectionId);
        HashSet<Node> nodes = new HashSet<Node>();
        int rootCount = this._ctEntryPersistence.countByC_MCNI_MCPK(ctCollectionId, modelClassNameId, modelClassPK);
        if (rootCount == 0) {
            Map pksMap = ctClosure.getChildPKsMap(modelClassNameId, modelClassPK);
            LinkedList queue = new LinkedList(pksMap.entrySet());
            Map.Entry entry = null;
            while ((entry = (Map.Entry)queue.poll()) != null) {
                long classNameId2 = (Long)entry.getKey();
                iterator = ((Collection)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    classPK2 = (Long)iterator.next();
                    int count = this._ctEntryPersistence.countByC_MCNI_MCPK(ctCollectionId, classNameId2, classPK2);
                    if (count == 0) {
                        Map childPKsMap = ctClosure.getChildPKsMap(classNameId2, classPK2);
                        if (childPKsMap.isEmpty()) continue;
                        queue.addAll(childPKsMap.entrySet());
                        continue;
                    }
                    nodes.add(new Node(classNameId2, classPK2));
                }
            }
        } else {
            nodes.add(new Node(modelClassNameId, modelClassPK));
        }
        HashMap<Long, Set<Long>> discardRootsMap = new HashMap<Long, Set<Long>>();
        CTEnclosureUtil.visitParentEntries(ctClosure, (classNameId, classPK, backtraceEntries) -> {
            if (!nodes.contains(new Node(classNameId, classPK))) {
                return false;
            }
            long previousModelClassNameId = classNameId;
            Iterator iterator = backtraceEntries.iterator();
            Map.Entry highestRequiredBacktraceEntry = null;
            while (iterator.hasNext()) {
                CTEntry ctEntry;
                Map.Entry backtraceEntry = (Map.Entry)iterator.next();
                long backtraceClassNameId = (Long)backtraceEntry.getKey();
                long backtraceClassPK = (Long)backtraceEntry.getValue();
                Set classPKs = (Set)discardRootsMap.get(backtraceClassNameId);
                if (classPKs != null && classPKs.contains(backtraceClassPK) || (ctEntry = this._ctEntryPersistence.fetchByC_MCNI_MCPK(ctCollectionId, backtraceClassNameId, backtraceClassPK)) == null || ctEntry.getChangeType() != 1 && this._tableReferenceDefinitionManager.isChildModelOptional(previousModelClassNameId, backtraceClassNameId)) break;
                highestRequiredBacktraceEntry = backtraceEntry;
                previousModelClassNameId = backtraceClassNameId;
            }
            if (highestRequiredBacktraceEntry != null) {
                Set classPKs = discardRootsMap.computeIfAbsent((Long)highestRequiredBacktraceEntry.getKey(), key -> new HashSet());
                classPKs.add(highestRequiredBacktraceEntry.getValue());
            }
            return true;
        });
        if (discardRootsMap.isEmpty()) {
            discardRootsMap.put(modelClassNameId, Collections.singleton(modelClassPK));
        }
        Map<Long, Set<Long>> discardEnclosureMap = CTEnclosureUtil.getEnclosureMap(ctClosure, discardRootsMap.entrySet());
        ArrayList<CTEntry> ctEntries = new ArrayList<CTEntry>(discardEnclosureMap.size());
        for (Map.Entry<Long, Set<Long>> entry : discardEnclosureMap.entrySet()) {
            iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                classPK2 = (Long)iterator.next();
                CTEntry ctEntry = this._ctEntryPersistence.fetchByC_MCNI_MCPK(ctCollectionId, entry.getKey().longValue(), classPK2);
                if (ctEntry == null) continue;
                ctEntries.add(ctEntry);
            }
        }
        return ctEntries;
    }

    private void _validate(String name, String description) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CTCollectionNameException();
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)CTCollection.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new CTCollectionNameException("Name is too long");
        }
        int descriptionMaxLength = ModelHintsUtil.getMaxLength((String)CTCollection.class.getName(), (String)"description");
        if (description != null && description.length() > descriptionMaxLength) {
            throw new CTCollectionDescriptionException("Description is too long");
        }
    }
}

