/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.search.spi.model.index.contributor;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.change.tracking.model.CTProcess"}, service={ModelDocumentContributor.class})
public class CTProcessModelDocumentContributor
implements ModelDocumentContributor<CTProcess> {
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;

    public void contribute(Document document, CTProcess ctProcess) {
        CTCollection ctCollection;
        document.addDate("createDate", ctProcess.getCreateDate());
        document.addKeyword("type", ctProcess.getType());
        document.addKeyword("userId", ctProcess.getUserId());
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchBackgroundTask(ctProcess.getBackgroundTaskId());
        if (backgroundTask != null) {
            document.addKeyword("status", backgroundTask.getStatus());
        }
        if ((ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctProcess.getCtCollectionId())) != null) {
            document.addText("description", ctCollection.getDescription());
            document.addText("name", ctCollection.getName());
        }
    }
}

