/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.search.spi.model.index.contributor;

import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.change.tracking.spi.display.CTDisplayRendererRegistry;
import com.liferay.portal.kernel.change.tracking.sql.CTSQLModeThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.change.tracking.model.CTEntry"}, service={ModelDocumentContributor.class})
public class CTEntryModelDocumentContributor
implements ModelDocumentContributor<CTEntry> {
    private static final Log _log = LogFactoryUtil.getLog(CTEntryModelDocumentContributor.class);
    @Reference
    private CTDisplayRendererRegistry _ctDisplayRendererRegistry;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private UserLocalService _userLocalService;

    public void contribute(Document document, CTEntry ctEntry) {
        document.addDate("createDate", ctEntry.getCreateDate());
        document.addDate("modified", ctEntry.getModifiedDate());
        User user = this._userLocalService.fetchUser(ctEntry.getUserId());
        if (user != null) {
            document.addKeyword("userId", user.getUserId());
            document.addText("userName", user.getFullName());
        }
        document.addKeyword("changeType", ctEntry.getChangeType());
        document.addKeyword("ctCollectionId", ctEntry.getCtCollectionId());
        document.addKeyword("modelClassNameId", ctEntry.getModelClassNameId());
        document.addKeyword("modelClassPK", ctEntry.getModelClassPK());
        this._indexModelAttributes(document, ctEntry);
    }

    private <T extends BaseModel<T>> Locale[] _getAvailableLocales(T model, CTDisplayRenderer ctDisplayRenderer) {
        Object[] languageIds = new String[]{};
        if (model != null) {
            languageIds = ctDisplayRenderer.getAvailableLanguageIds(model);
        }
        if (ArrayUtil.isNotEmpty((Object[])languageIds)) {
            return LocaleUtil.fromLanguageIds((String[])languageIds);
        }
        Set locales = this._language.getAvailableLocales();
        return locales.toArray(new Locale[0]);
    }

    private <T extends BaseModel<T>> Map<Locale, String> _getTitleMap(Locale[] locales, T model, long modelClassNameId) {
        CTDisplayRenderer ctDisplayRenderer = this._ctDisplayRendererRegistry.getCTDisplayRenderer(modelClassNameId);
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : locales) {
            try {
                map.put(locale, ctDisplayRenderer.getTitle(locale, model));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
        return map;
    }

    private Map<Locale, String> _getTypeNameMap(Locale[] locales, long modelClassNameId) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : locales) {
            map.put(locale, this._ctDisplayRendererRegistry.getTypeName(locale, modelClassNameId));
        }
        return map;
    }

    private <T extends BaseModel<T>> void _indexModelAttributes(Document document, CTEntry ctEntry) {
        GroupedModel groupedModel;
        Group group;
        long ctCollectionId = ctEntry.getCtCollectionId();
        if (ctEntry.getChangeType() == 1) {
            ctCollectionId = 0L;
        }
        BaseModel model = this._ctDisplayRendererRegistry.fetchCTModel(ctCollectionId, CTSQLModeThreadLocal.CTSQLMode.DEFAULT, ctEntry.getModelClassNameId(), ctEntry.getModelClassPK());
        Locale[] locales = this._getAvailableLocales(model, this._ctDisplayRendererRegistry.getCTDisplayRenderer(ctEntry.getModelClassNameId()));
        document.addLocalizedKeyword("typeName", this._getTypeNameMap(locales, ctEntry.getModelClassNameId()));
        if (model == null) {
            return;
        }
        if (model instanceof GroupedModel && (group = this._groupLocalService.fetchGroup((groupedModel = (GroupedModel)model).getGroupId())) != null) {
            document.addKeyword("groupId", group.getGroupId());
            document.addLocalizedKeyword("groupName", group.getNameMap());
        }
        document.addLocalizedText("title", this._getTitleMap(locales, model, ctEntry.getModelClassNameId()));
        document.addKeyword("hideable", this._ctDisplayRendererRegistry.isHideable(model, ctEntry.getModelClassNameId()));
        Map modelAttributes = model.getModelAttributes();
        if (modelAttributes.containsKey("status")) {
            document.addKeyword("workflowStatus", (Integer)modelAttributes.get("status"));
        }
    }
}

