/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.search.spi.model.index.contributor;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.change.tracking.model.CTCollection"}, service={ModelDocumentContributor.class})
public class CTCollectionModelDocumentContributor
implements ModelDocumentContributor<CTCollection> {
    private static final Log _log = LogFactoryUtil.getLog(CTCollectionModelDocumentContributor.class);
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private UserLocalService _userLocalService;

    public void contribute(Document document, CTCollection ctCollection) {
        document.addDate("createDate", ctCollection.getCreateDate());
        document.addText("description", ctCollection.getDescription());
        document.addDate("modified", ctCollection.getModifiedDate());
        document.addText("name", ctCollection.getName());
        document.addKeyword("status", ctCollection.getStatus());
        User user = this._userLocalService.fetchUser(ctCollection.getUserId());
        if (user != null) {
            document.addKeyword("userId", user.getUserId());
            document.addText("userName", user.getFullName());
        }
        document.addDate("scheduledDate", this._getScheduledDate(ctCollection));
    }

    private Date _getScheduledDate(CTCollection ctCollection) {
        if (ctCollection.getStatus() != 7) {
            return null;
        }
        try {
            SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(String.valueOf(ctCollection.getCtCollectionId()), "liferay/ct_collection_scheduled_publish", StorageType.PERSISTED);
            if (schedulerResponse == null) {
                return null;
            }
            return this._schedulerEngineHelper.getStartTime(schedulerResponse);
        }
        catch (SchedulerException schedulerException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)schedulerException);
            }
            return null;
        }
    }
}

