/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.reference;

import com.liferay.change.tracking.internal.reference.TableJoinHolder;
import com.liferay.change.tracking.internal.reference.TableReferenceInfo;
import com.liferay.change.tracking.internal.reference.TableReferenceInfoFactory;
import com.liferay.change.tracking.internal.reference.TableUtil;
import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={TableReferenceDefinitionManager.class})
public class TableReferenceDefinitionManager {
    private static final Log _log = LogFactoryUtil.getLog(TableReferenceDefinitionManager.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private volatile Map<Long, TableReferenceInfo<?>> _combinedTableReferenceInfos;
    private volatile boolean _opened;
    private ServiceTracker<?, ?> _serviceTracker;
    private final Map<String, TableReferenceInfo<?>> _tableReferenceInfos = new ConcurrentHashMap();

    public long getClassNameId(String tableName) {
        this._ensureOpened();
        TableReferenceInfo<?> tableReferenceInfo = this._tableReferenceInfos.get(tableName);
        if (tableReferenceInfo == null) {
            throw new IllegalStateException("No table reference definition for " + tableName);
        }
        return tableReferenceInfo.getClassNameId();
    }

    public long getClassNameId(Table<?> table) {
        return this.getClassNameId(table.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, TableReferenceInfo<?>> getCombinedTableReferenceInfos() {
        this._ensureOpened();
        Map<Long, TableReferenceInfo<?>> combinedTableReferenceInfos = this._combinedTableReferenceInfos;
        if (combinedTableReferenceInfos != null) {
            return combinedTableReferenceInfos;
        }
        TableReferenceDefinitionManager tableReferenceDefinitionManager = this;
        synchronized (tableReferenceDefinitionManager) {
            combinedTableReferenceInfos = new HashMap();
            for (TableReferenceInfo<?> tableReferenceInfo : this._tableReferenceInfos.values()) {
                combinedTableReferenceInfos.put(tableReferenceInfo.getClassNameId(), this._getCombinedTableReferenceInfo(tableReferenceInfo));
            }
            combinedTableReferenceInfos = Collections.unmodifiableMap(combinedTableReferenceInfos);
            this._combinedTableReferenceInfos = combinedTableReferenceInfos;
        }
        return combinedTableReferenceInfos;
    }

    public Map<Long, TableReferenceInfo<?>> getCombinedTableReferenceInfos(long classNameId) {
        HashMap combinedTableReferenceInfos = new HashMap();
        Map<Long, TableReferenceInfo<?>> allCombinedTableReferenceInfos = this.getCombinedTableReferenceInfos();
        LinkedList<Long> queue = new LinkedList<Long>();
        queue.add(classNameId);
        while (queue.size() > 0) {
            classNameId = (Long)queue.poll();
            TableReferenceInfo<?> tableReferenceInfo = allCombinedTableReferenceInfos.get(classNameId);
            combinedTableReferenceInfos.put(classNameId, tableReferenceInfo);
            Map<Table<?>, List<TableJoinHolder>> parentTableJoinHoldersMap = tableReferenceInfo.getParentTableJoinHoldersMap();
            Map<Table<?>, List<TableJoinHolder>> childTableJoinHoldersMap = tableReferenceInfo.getChildTableJoinHoldersMap();
            for (Table<?> table : childTableJoinHoldersMap.keySet()) {
                long childClassNameId = this.getClassNameId(table);
                if (parentTableJoinHoldersMap.containsKey(table)) {
                    combinedTableReferenceInfos.put(childClassNameId, allCombinedTableReferenceInfos.get(childClassNameId));
                    continue;
                }
                if (combinedTableReferenceInfos.containsKey(childClassNameId)) continue;
                queue.add(childClassNameId);
            }
        }
        return combinedTableReferenceInfos;
    }

    public boolean isChildModelOptional(long childModelClassNameId, long parentModelClassNameId) {
        TableReferenceDefinition<?> childTableReferenceDefinition;
        Map<Long, TableReferenceInfo<?>> combinedTableReferenceInfos = this.getCombinedTableReferenceInfos();
        TableReferenceInfo<?> parentTableReferenceInfo = combinedTableReferenceInfos.get(parentModelClassNameId);
        if (parentTableReferenceInfo == null) {
            throw new IllegalArgumentException("{parentModelClassNameId=" + parentModelClassNameId + "}");
        }
        TableReferenceInfo<?> childTableReferenceInfo = combinedTableReferenceInfos.get(childModelClassNameId);
        if (childTableReferenceInfo == null) {
            throw new IllegalArgumentException("{childModelClassNameId=" + childModelClassNameId + "}");
        }
        Map<Table<?>, List<TableJoinHolder>> childTableJoinHoldersMap = parentTableReferenceInfo.getChildTableJoinHoldersMap();
        List<TableJoinHolder> tableJoinHolders = childTableJoinHoldersMap.get((childTableReferenceDefinition = childTableReferenceInfo.getTableReferenceDefinition()).getTable());
        if (tableJoinHolders == null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{childModelClassNameId=", childModelClassNameId, ", parentModelClassNameId=", parentModelClassNameId, "}"}));
        }
        for (TableJoinHolder tableJoinHolder : tableJoinHolders) {
            if (tableJoinHolder.isReversed()) continue;
            return false;
        }
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTracker = new ServiceTracker(bundleContext, TableReferenceDefinition.class, (ServiceTrackerCustomizer)new TableReferenceDefinitionServiceTrackerCustomizer(bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private Map<Table<?>, List<TableJoinHolder>> _copyTableJoinHoldersMap(Map<Table<?>, List<TableJoinHolder>> tableJoinHoldersMap) {
        HashMap copy = new HashMap();
        for (Map.Entry<Table<?>, List<TableJoinHolder>> entry : tableJoinHoldersMap.entrySet()) {
            copy.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _ensureOpened() {
        if (this._opened) {
            return;
        }
        TableReferenceDefinitionManager tableReferenceDefinitionManager = this;
        synchronized (tableReferenceDefinitionManager) {
            if (this._opened) {
                return;
            }
            this._serviceTracker.open();
            this._opened = true;
        }
    }

    private <T extends Table<T>> TableReferenceInfo<T> _getCombinedTableReferenceInfo(TableReferenceInfo<T> tableReferenceInfo) {
        Map<Table<?>, List<TableJoinHolder>> combinedParentTableJoinHoldersMap = this._copyTableJoinHoldersMap(tableReferenceInfo.getParentTableJoinHoldersMap());
        Map<Table<?>, List<TableJoinHolder>> combinedChildTableJoinHoldersMap = this._copyTableJoinHoldersMap(tableReferenceInfo.getChildTableJoinHoldersMap());
        TableReferenceDefinition<T> tableReferenceDefinition = tableReferenceInfo.getTableReferenceDefinition();
        Table table = tableReferenceDefinition.getTable();
        for (TableReferenceInfo<?> currentTableReferenceInfo : this._tableReferenceInfos.values()) {
            Map<Table<?>, List<TableJoinHolder>> currentChildTableJoinHoldersMap;
            List<TableJoinHolder> currentChildTableJoinHolders;
            TableReferenceDefinition<?> currentTableReferenceDefinition = currentTableReferenceInfo.getTableReferenceDefinition();
            Map<Table<?>, List<TableJoinHolder>> currentParentTableJoinHoldersMap = currentTableReferenceInfo.getParentTableJoinHoldersMap();
            List<TableJoinHolder> currentParentTableJoinHolders = currentParentTableJoinHoldersMap.get(table);
            if (currentParentTableJoinHolders != null) {
                List combinedChildTableJoinHolders = combinedChildTableJoinHoldersMap.computeIfAbsent(currentTableReferenceDefinition.getTable(), key -> new ArrayList());
                for (TableJoinHolder currentParentTableJoinHolder : currentParentTableJoinHolders) {
                    combinedChildTableJoinHolders.add(TableJoinHolder.reverse(currentParentTableJoinHolder));
                }
            }
            if ((currentChildTableJoinHolders = (currentChildTableJoinHoldersMap = currentTableReferenceInfo.getChildTableJoinHoldersMap()).get(table)) == null) continue;
            List combinedParentTableJoinHolders = combinedParentTableJoinHoldersMap.computeIfAbsent(currentTableReferenceDefinition.getTable(), key -> new ArrayList());
            for (TableJoinHolder currentChildTableJoinHolder : currentChildTableJoinHolders) {
                combinedParentTableJoinHolders.add(TableJoinHolder.reverse(currentChildTableJoinHolder));
            }
        }
        return new TableReferenceInfo<T>(combinedChildTableJoinHoldersMap, tableReferenceInfo.getClassNameId(), combinedParentTableJoinHoldersMap, tableReferenceDefinition);
    }

    private class TableReferenceDefinitionServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<TableReferenceDefinition<?>, TableReferenceInfo<?>> {
        private final BundleContext _bundleContext;

        public TableReferenceInfo<?> addingService(ServiceReference<TableReferenceDefinition<?>> serviceReference) {
            TableReferenceDefinition tableReferenceDefinition = (TableReferenceDefinition)this._bundleContext.getService(serviceReference);
            return this._createTableReferenceContext(tableReferenceDefinition);
        }

        public void modifiedService(ServiceReference<TableReferenceDefinition<?>> serviceReference, TableReferenceInfo<?> tableReferenceInfo) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<TableReferenceDefinition<?>> serviceReference, TableReferenceInfo<?> tableReferenceInfo) {
            TableReferenceDefinition<?> tableReferenceDefinition = tableReferenceInfo.getTableReferenceDefinition();
            Table table = tableReferenceDefinition.getTable();
            TableReferenceDefinitionManager tableReferenceDefinitionManager = TableReferenceDefinitionManager.this;
            synchronized (tableReferenceDefinitionManager) {
                TableReferenceDefinitionManager.this._tableReferenceInfos.remove(table.getTableName());
                TableReferenceDefinitionManager.this._combinedTableReferenceInfos = null;
            }
            this._bundleContext.ungetService(serviceReference);
        }

        private TableReferenceDefinitionServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T extends Table<T>> TableReferenceInfo<?> _createTableReferenceContext(TableReferenceDefinition<T> tableReferenceDefinition) {
            Column primaryKeyColumn = TableUtil.getPrimaryKeyColumn(tableReferenceDefinition.getTable());
            if (primaryKeyColumn == null) {
                _log.error((Object)("No long type primary key column found for " + tableReferenceDefinition));
                return null;
            }
            BasePersistence basePersistence = tableReferenceDefinition.getBasePersistence();
            TableReferenceInfo tableReferenceInfo = TableReferenceInfoFactory.create(TableReferenceDefinitionManager.this._classNameLocalService.getClassNameId(basePersistence.getModelClass()), primaryKeyColumn, tableReferenceDefinition);
            Table table = tableReferenceDefinition.getTable();
            TableReferenceDefinitionManager tableReferenceDefinitionManager = TableReferenceDefinitionManager.this;
            synchronized (tableReferenceDefinitionManager) {
                TableReferenceDefinitionManager.this._tableReferenceInfos.put(table.getTableName(), tableReferenceInfo);
                TableReferenceDefinitionManager.this._combinedTableReferenceInfos = null;
            }
            return tableReferenceInfo;
        }
    }
}

