/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.closure;

import com.liferay.change.tracking.closure.CTClosure;
import com.liferay.change.tracking.closure.CTClosureFactory;
import com.liferay.change.tracking.internal.closure.CTClosureImpl;
import com.liferay.change.tracking.internal.closure.Edge;
import com.liferay.change.tracking.internal.closure.Node;
import com.liferay.change.tracking.internal.reference.TableJoinHolder;
import com.liferay.change.tracking.internal.reference.TableReferenceDefinitionManager;
import com.liferay.change.tracking.internal.reference.TableReferenceInfo;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.service.persistence.CTCollectionPersistence;
import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.spi.ast.DefaultASTNodeListener;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTClosureFactory.class})
public class CTClosureFactoryImpl
implements CTClosureFactory {
    private static final int _SQL_PLACEHOLDER_LIMIT = 65533;
    private static final Log _log = LogFactoryUtil.getLog(CTClosureFactoryImpl.class);
    @Reference
    private CTCollectionPersistence _ctCollectionPersistence;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private TableReferenceDefinitionManager _tableReferenceDefinitionManager;

    public CTClosure create(long ctCollectionId) {
        return this.create(ctCollectionId, 0L);
    }

    public CTClosure create(long ctCollectionId, long classNameId) {
        Map<Long, TableReferenceInfo<?>> combinedTableReferenceInfos = classNameId > 0L ? this._tableReferenceDefinitionManager.getCombinedTableReferenceInfos(classNameId) : this._tableReferenceDefinitionManager.getCombinedTableReferenceInfos();
        return new CTClosureImpl(ctCollectionId, this._buildClosureMap(ctCollectionId, classNameId, combinedTableReferenceInfos));
    }

    private Map<Node, Collection<Node>> _buildClosureMap(long ctCollectionId, long classNameId, Map<Long, TableReferenceInfo<?>> combinedTableReferenceInfos) {
        LinkedHashMap<Long, List> map = new LinkedHashMap<Long, List>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList ctEntries = new ArrayList(this._ctEntryLocalService.getCTCollectionCTEntries(ctCollectionId));
        ctEntries.sort((ctEntry1, ctEntry2) -> (int)(ctEntry1.getCtEntryId() - ctEntry2.getCtEntryId()));
        for (CTEntry ctEntry : ctEntries) {
            if (classNameId > 0L && !combinedTableReferenceInfos.containsKey(ctEntry.getModelClassNameId())) continue;
            List primaryKeys = map.computeIfAbsent(ctEntry.getModelClassNameId(), key -> new ArrayList());
            primaryKeys.add(ctEntry.getModelClassPK());
            nodes.add(new Node(ctEntry.getModelClassNameId(), ctEntry.getModelClassPK()));
        }
        LinkedHashMap<Node, Collection<Edge>> edgeMap = new LinkedHashMap<Node, Collection<Edge>>();
        LinkedList queue = new LinkedList(map.entrySet());
        while (queue.size() > 0) {
            Map.Entry queueEntry = (Map.Entry)queue.poll();
            long childClassNameId = (Long)queueEntry.getKey();
            TableReferenceInfo<?> childTableReferenceInfo = combinedTableReferenceInfos.get(childClassNameId);
            if (childTableReferenceInfo == null) {
                CTCollection ctCollection = this._ctCollectionPersistence.fetchByPrimaryKey(ctCollectionId);
                if (ctCollection != null && ctCollection.getStatus() != 2 && ctCollection.getStatus() != 1) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("No table reference definition for " + childClassNameId));
                    continue;
                }
                throw new IllegalArgumentException("No table reference definition for " + childClassNameId);
            }
            List childPrimaryKeys = (List)queueEntry.getValue();
            Long[] childPrimaryKeysArray = childPrimaryKeys.toArray(new Long[0]);
            Map<Table<?>, List<TableJoinHolder>> parentTableJoinHoldersMap = childTableReferenceInfo.getParentTableJoinHoldersMap();
            for (Map.Entry<Table<?>, List<TableJoinHolder>> entry : parentTableJoinHoldersMap.entrySet()) {
                int batchSize;
                long parentClassNameId = this._tableReferenceDefinitionManager.getClassNameId(entry.getKey());
                if (classNameId > 0L && !map.containsKey(parentClassNameId)) continue;
                TableReferenceInfo<?> parentTableReferenceInfo = combinedTableReferenceInfos.get(parentClassNameId);
                for (int i = 0; i < childPrimaryKeysArray.length; i += batchSize) {
                    batchSize = 65533;
                    if (i + batchSize > childPrimaryKeysArray.length) {
                        batchSize = childPrimaryKeysArray.length - i;
                    }
                    Long[] batchChildPrimaryKeys = new Long[batchSize];
                    System.arraycopy(childPrimaryKeysArray, i, batchChildPrimaryKeys, 0, batchSize);
                    List<Long> newParentPrimaryKeys = this._collectParentPrimaryKeys(childClassNameId, batchChildPrimaryKeys, ctCollectionId, entry, edgeMap, nodes, parentClassNameId, classNameId, parentTableReferenceInfo);
                    if (newParentPrimaryKeys == null) continue;
                    queue.add(new AbstractMap.SimpleImmutableEntry<Long, List<Long>>(parentClassNameId, newParentPrimaryKeys));
                }
            }
        }
        return this._getNodeMap(nodes, edgeMap);
    }

    private List<Long> _collectParentPrimaryKeys(long childClassNameId, Long[] childPrimaryKeys, long ctCollectionId, Map.Entry<Table<?>, List<TableJoinHolder>> entry, Map<Node, Collection<Edge>> edgeMap, List<Node> nodes, long parentClassNameId, long classNameId, TableReferenceInfo<?> parentTableReferenceInfo) {
        ArrayList<Long> newParentPrimaryKeys = null;
        DSLQuery dslQuery = this._getDSLQuery(ctCollectionId, childPrimaryKeys, entry.getValue());
        try (Connection connection = this._getConnection(parentTableReferenceInfo);
             PreparedStatement preparedStatement = this._getPreparedStatement(connection, dslQuery);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                Node parentNode = new Node(parentClassNameId, resultSet.getLong(1));
                if (classNameId > 0L && !nodes.contains(parentNode)) continue;
                Node childNode = new Node(childClassNameId, resultSet.getLong(2));
                if (!nodes.contains(parentNode)) {
                    nodes.add(parentNode);
                    if (newParentPrimaryKeys == null) {
                        newParentPrimaryKeys = new ArrayList<Long>();
                    }
                    newParentPrimaryKeys.add(parentNode.getPrimaryKey());
                }
                Collection edges = edgeMap.computeIfAbsent(parentNode, key -> new LinkedList());
                edges.add(new Edge(parentNode, childNode));
            }
        }
        catch (SQLException sqlException) {
            throw new ORMException("Unable to execute query: " + dslQuery, (Throwable)sqlException);
        }
        return newParentPrimaryKeys;
    }

    private void _filterCyclingEdges(Edge edge, Map<Node, Collection<Edge>> edgeMap, Deque<Edge> backtraceEdges, Set<Edge> cyclingEdges, Set<Edge> resolvedEdges) {
        if (backtraceEdges.contains(edge)) {
            cyclingEdges.add(edge);
            return;
        }
        if (resolvedEdges.contains(edge) || cyclingEdges.contains(edge)) {
            return;
        }
        Collection<Edge> nextEdges = edgeMap.get(edge.getToNode());
        if (nextEdges == null) {
            resolvedEdges.add(edge);
            return;
        }
        backtraceEdges.push(edge);
        for (Edge nextEdge : nextEdges) {
            this._filterCyclingEdges(nextEdge, edgeMap, backtraceEdges, cyclingEdges, resolvedEdges);
        }
        backtraceEdges.pop();
        if (!cyclingEdges.contains(edge)) {
            resolvedEdges.add(edge);
        }
    }

    private Predicate _getChildPKColumnPredicate(Column<?, Long> childPKColumn, Long[] childPrimaryKeysArray) {
        int batchSize;
        Predicate predicate = null;
        for (int i = 0; i < childPrimaryKeysArray.length; i += batchSize) {
            batchSize = 1000;
            if (i + batchSize > childPrimaryKeysArray.length) {
                batchSize = childPrimaryKeysArray.length - i;
            }
            Object[] batchChildPrimaryKeys = new Long[batchSize];
            System.arraycopy(childPrimaryKeysArray, i, batchChildPrimaryKeys, 0, batchSize);
            predicate = predicate == null ? childPKColumn.in(batchChildPrimaryKeys) : predicate.or((Expression)childPKColumn.in(batchChildPrimaryKeys));
        }
        return predicate.withParentheses();
    }

    private Connection _getConnection(TableReferenceInfo<?> tableReferenceInfo) throws SQLException {
        TableReferenceDefinition<?> tableReferenceDefinition = tableReferenceInfo.getTableReferenceDefinition();
        BasePersistence basePersistence = tableReferenceDefinition.getBasePersistence();
        DataSource dataSource = basePersistence.getDataSource();
        return dataSource.getConnection();
    }

    private DSLQuery _getDSLQuery(long ctCollectionId, Long[] childPrimaryKeysArray, List<TableJoinHolder> tableJoinHolders) {
        GroupByStep dslQuery = null;
        for (TableJoinHolder parentJoinHolder : tableJoinHolders) {
            Column<?, Long> parentPKColumn = parentJoinHolder.getParentPKColumn();
            Column<?, Long> childPKColumn = parentJoinHolder.getChildPKColumn();
            FromStep fromStep = DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{parentPKColumn, childPKColumn});
            Function<FromStep, JoinStep> joinFunction = parentJoinHolder.getJoinFunction();
            JoinStep joinStep = joinFunction.apply(fromStep);
            GroupByStep groupByStep = joinStep.where(() -> this._getChildPKColumnPredicate(childPKColumn, childPrimaryKeysArray).and(() -> {
                Table parentTable = parentPKColumn.getTable();
                Column ctCollectionIdColumn = parentTable.getColumn("ctCollectionId", Long.class);
                if (ctCollectionIdColumn != null && ctCollectionIdColumn.isPrimaryKey()) {
                    return ctCollectionIdColumn.eq((Object)0L).or((Expression)ctCollectionIdColumn.eq((Object)ctCollectionId)).withParentheses();
                }
                return null;
            }));
            if (dslQuery == null) {
                dslQuery = groupByStep;
                continue;
            }
            dslQuery = dslQuery.union((DSLQuery)groupByStep);
        }
        return dslQuery;
    }

    private Map<Node, Collection<Node>> _getNodeMap(List<Node> nodes, Map<Node, Collection<Edge>> edgeMap) {
        LinkedList<Edge> backtraceEdges = new LinkedList<Edge>();
        HashSet<Edge> cyclingEdges = new HashSet<Edge>();
        HashSet<Edge> resolvedEdges = new HashSet<Edge>();
        for (Collection<Edge> edges : edgeMap.values()) {
            for (Edge edge : edges) {
                this._filterCyclingEdges(edge, edgeMap, backtraceEdges, cyclingEdges, resolvedEdges);
            }
        }
        HashMap<Node, Collection<Node>> nodeMap = new HashMap<Node, Collection<Node>>();
        for (Edge edge : resolvedEdges) {
            Collection children = nodeMap.computeIfAbsent(edge.getFromNode(), node -> new ArrayList());
            Node toNode = edge.getToNode();
            children.add(toNode);
            nodes.remove(toNode);
        }
        nodeMap.put(Node.ROOT_NODE, nodes);
        return nodeMap;
    }

    private PreparedStatement _getPreparedStatement(Connection connection, DSLQuery dslQuery) throws SQLException {
        DefaultASTNodeListener defaultASTNodeListener = new DefaultASTNodeListener();
        PreparedStatement preparedStatement = connection.prepareStatement(SQLTransformer.transform((String)dslQuery.toSQL((ASTNodeListener)defaultASTNodeListener)));
        List scalarValues = defaultASTNodeListener.getScalarValues();
        for (int i = 0; i < scalarValues.size(); ++i) {
            preparedStatement.setObject(i + 1, scalarValues.get(i));
        }
        return preparedStatement;
    }
}

