/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal;

import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTPersistenceHelper.class})
public class CTPersistenceHelperImpl
implements CTPersistenceHelper {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;

    public <T extends CTModel<T>> boolean isInsert(T ctModel) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        ctModel.setCtCollectionId(ctCollectionId);
        if (ctCollectionId == 0L) {
            return ctModel.isNew();
        }
        long modelClassNameId = this._classNameLocalService.getClassNameId(ctModel.getModelClass());
        long modelClassPK = ctModel.getPrimaryKey();
        CTEntry ctEntry = this._ctEntryLocalService.fetchCTEntry(ctCollectionId, modelClassNameId, modelClassPK);
        long userId = PrincipalThreadLocal.getUserId();
        try {
            if (ctEntry == null) {
                int changeType = 2;
                if (ctModel.isNew()) {
                    changeType = 0;
                }
                this._ctEntryLocalService.addCTEntry(ctCollectionId, modelClassNameId, ctModel, userId, changeType);
                return true;
            }
            if (userId != ctEntry.getUserId()) {
                ctEntry.setUserId(userId);
                this._ctEntryLocalService.updateCTEntry(ctEntry);
            }
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
        return false;
    }

    public <T extends CTModel<T>> boolean isProductionMode(Class<T> ctModelClass) {
        return this.isProductionMode(ctModelClass, null);
    }

    public <T extends CTModel<T>> boolean isProductionMode(Class<T> ctModelClass, Serializable primaryKey) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return true;
        }
        long modelClassNameId = this._classNameLocalService.getClassNameId(ctModelClass);
        if (primaryKey instanceof Long) {
            return !this._ctEntryLocalService.hasCTEntry(ctCollectionId, modelClassNameId, ((Long)primaryKey).longValue());
        }
        return !this._ctEntryLocalService.hasCTEntries(ctCollectionId, modelClassNameId);
    }

    public <T extends CTModel<T>> boolean isRemove(T ctModel) {
        if (ctModel == null) {
            return false;
        }
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return true;
        }
        long modelClassNameId = this._classNameLocalService.getClassNameId(ctModel.getModelClass());
        long modelClassPK = ctModel.getPrimaryKey();
        CTEntry ctEntry = this._ctEntryLocalService.fetchCTEntry(ctCollectionId, modelClassNameId, modelClassPK);
        try {
            if (ctEntry == null) {
                this._ctEntryLocalService.addCTEntry(ctCollectionId, modelClassNameId, ctModel, PrincipalThreadLocal.getUserId(), 1);
            } else {
                int changeType = ctEntry.getChangeType();
                if (changeType == 0) {
                    this._ctEntryLocalService.deleteCTEntry(ctEntry);
                    return true;
                }
                ctEntry.setChangeType(1);
                this._ctEntryLocalService.updateCTEntry(ctEntry);
                if (changeType == 2 && ctModel.getCtCollectionId() != 0L) {
                    return true;
                }
            }
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
        return false;
    }
}

