/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.PortletPreferenceValueTable;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.persistence.PortletPreferenceValuePersistence;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class PortletPreferenceConstraintResolver
implements ConstraintResolver<PortletPreferences> {
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletPreferenceValueLocalService _portletPreferenceValueLocalService;
    @Reference
    private PortletPreferenceValuePersistence _portletPreferenceValuePersistence;

    public String getConflictDescriptionKey() {
        return "duplicate-widget-preferences";
    }

    public Class<PortletPreferences> getModelClass() {
        return PortletPreferences.class;
    }

    public String getResolutionDescriptionKey() {
        return "duplicate-widget-preferences-were-removed";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, PortletPreferenceConstraintResolver.class);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"ownerId", "ownerType", "plid", "portletId"};
    }

    public void resolveConflict(ConstraintResolverContext<PortletPreferences> constraintResolverContext) throws PortalException {
        PortletPreferences sourcePortletPreferences = (PortletPreferences)constraintResolverContext.getSourceCTModel();
        this._portletPreferencesLocalService.deletePortletPreferences((PortletPreferences)constraintResolverContext.getSourceCTModel());
        List portletPreferenceValueIds = (List)this._portletPreferenceValueLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{PortletPreferenceValueTable.INSTANCE.portletPreferenceValueId}).from((Table)PortletPreferenceValueTable.INSTANCE).where(PortletPreferenceValueTable.INSTANCE.portletPreferencesId.eq((Object)sourcePortletPreferences.getPortletPreferencesId()).and((Expression)PortletPreferenceValueTable.INSTANCE.ctCollectionId.eq((Object)sourcePortletPreferences.getCtCollectionId()))));
        Iterator iterator = portletPreferenceValueIds.iterator();
        while (iterator.hasNext()) {
            long portletPreferenceValueId = (Long)iterator.next();
            this._portletPreferenceValueLocalService.deletePortletPreferenceValue(portletPreferenceValueId);
        }
    }
}

