/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.security.permission.resource;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.change.tracking.model.CTCollection"}, service={ModelResourcePermission.class})
public class CTCollectionModelResourcePermission
implements ModelResourcePermission<CTCollection> {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(resource.name=com.liferay.change.tracking)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, CTCollection ctCollection, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ctCollection, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CTCollection.class.getName(), ctCollection.getCtCollectionId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long ctCollectionId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ctCollectionId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CTCollection.class.getName(), ctCollectionId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CTCollection ctCollection, String actionId) {
        if (permissionChecker.hasOwnerPermission(ctCollection.getCompanyId(), CTCollection.class.getName(), ctCollection.getCtCollectionId(), ctCollection.getUserId(), actionId)) {
            return true;
        }
        Group group = this._groupLocalService.fetchGroup(ctCollection.getCompanyId(), this._classNameLocalService.getClassNameId(CTCollection.class), ctCollection.getCtCollectionId());
        return permissionChecker.hasPermission(group, CTCollection.class.getName(), ctCollection.getCtCollectionId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long ctCollectionId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._ctCollectionLocalService.getCTCollection(ctCollectionId), actionId);
    }

    public String getModelName() {
        return CTCollection.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

