/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.search.spi.model.query.contributor;

import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.model.uid.UIDFactory;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=ALL", "indexer.clauses.mandatory=true"}, service={ModelPreFilterContributor.class})
public class CTModelPreFilterContributor
implements ModelPreFilterContributor {
    private static final String _CT_COLLECTION_ID = "ctCollectionId";
    private static final Filter _CT_COLLECTION_ID_MISSING_FILTER = new MissingFilter("ctCollectionId");
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    private ServiceTrackerMap<String, CTService<?>> _serviceTrackerMap;
    @Reference
    private UIDFactory _uidFactory;

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        String className = modelSearchSettings.getClassName();
        if (!this._serviceTrackerMap.containsKey((Object)className)) {
            return;
        }
        String ctCollectionIdString = GetterUtil.getString((Object)searchContext.getAttribute("com.liferay.change.tracking.filter.ctCollectionId"));
        if (Objects.equals("ALL", ctCollectionIdString)) {
            return;
        }
        BooleanFilter ctBooleanFilter = new BooleanFilter();
        long ctCollectionId = GetterUtil.getLong((String)ctCollectionIdString, (long)CTCollectionThreadLocal.getCTCollectionId());
        if (ctCollectionId == 0L) {
            if (!GetterUtil.getBoolean((Object)searchContext.getAttribute("relatedClassName"))) {
                ctBooleanFilter.add(_CT_COLLECTION_ID_MISSING_FILTER, BooleanClauseOccur.MUST);
            }
        } else {
            ArrayList<Long> excludeModelClassPKs = new ArrayList<Long>();
            for (CTEntry ctEntry : this._ctEntryLocalService.getCTEntries(ctCollectionId, this._classNameLocalService.getClassNameId(className))) {
                int changeType = ctEntry.getChangeType();
                if (changeType != 1 && changeType != 2) continue;
                excludeModelClassPKs.add(ctEntry.getModelClassPK());
            }
            ctBooleanFilter.add(_CT_COLLECTION_ID_MISSING_FILTER, BooleanClauseOccur.SHOULD);
            TermsFilter ctCollectionIdTermsFilter = new TermsFilter(_CT_COLLECTION_ID);
            ctCollectionIdTermsFilter.addValue(String.valueOf(ctCollectionId));
            ctCollectionIdTermsFilter.addValue(String.valueOf(0L));
            ctBooleanFilter.add((Filter)ctCollectionIdTermsFilter, BooleanClauseOccur.SHOULD);
            if (!excludeModelClassPKs.isEmpty()) {
                TermsFilter uidTermsFilter = new TermsFilter("uid");
                for (Long classPK : excludeModelClassPKs) {
                    uidTermsFilter.addValue(this._uidFactory.getUID(className, (Serializable)((Object)String.valueOf(classPK)), 0L));
                }
                ctBooleanFilter.add((Filter)uidTermsFilter, BooleanClauseOccur.MUST_NOT);
            }
        }
        if (ctBooleanFilter.hasClauses()) {
            booleanFilter.add((Filter)ctBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CTService.class, null, (serviceReference, emitter) -> {
            CTService ctService = (CTService)bundleContext.getService(serviceReference);
            Class modelClass = ctService.getModelClass();
            emitter.emit((Object)modelClass.getName());
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

