/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.model.listener;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.CTPreferences;
import com.liferay.change.tracking.model.CTPreferencesTable;
import com.liferay.change.tracking.model.CTSchemaVersion;
import com.liferay.change.tracking.model.CTSchemaVersionTable;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.change.tracking.service.CTSchemaVersionLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.ReleaseTable;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.model.impl.ReleaseImpl;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ReleaseModelListener
extends BaseModelListener<Release> {
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;
    @Reference
    private CTSchemaVersionLocalService _ctSchemaVersionLocalService;
    @Reference(target="(module.service.lifecycle=portlets.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;

    public void onBeforeCreate(Release release) {
        if (!Objects.equals(release.getSchemaVersion(), "0.0.0")) {
            this._resetCTPreferences();
        }
    }

    public void onBeforeRemove(Release release) {
        this._resetCTPreferences();
    }

    public void onBeforeUpdate(Release originalRelease, Release release) {
        ReleaseImpl releaseImpl = (ReleaseImpl)release;
        String originalSchemaVersion = (String)releaseImpl.getColumnOriginalValue(ReleaseTable.INSTANCE.schemaVersion.getName());
        if (!Objects.equals(originalSchemaVersion, releaseImpl.getSchemaVersion())) {
            Version version1 = Version.parseVersion((String)originalSchemaVersion);
            Version version2 = Version.parseVersion((String)release.getSchemaVersion());
            if (version1.getMajor() != version2.getMajor() || version1.getMinor() != version2.getMinor()) {
                this._resetCTPreferences();
            }
        }
    }

    @Activate
    protected void activate() {
        List ctSchemaVersions = (List)this._ctSchemaVersionLocalService.dslQuery(DSLQueryFactoryUtil.select((Table)CTSchemaVersionTable.INSTANCE).from((Table)CTSchemaVersionTable.INSTANCE).orderBy(new OrderByExpression[]{CTSchemaVersionTable.INSTANCE.schemaVersionId.descending()}).limit(0, 1));
        if (!ctSchemaVersions.isEmpty() && !this._ctSchemaVersionLocalService.isLatestCTSchemaVersion((CTSchemaVersion)ctSchemaVersions.get(0), false)) {
            this._resetCTPreferences();
        }
    }

    private void _resetCTPreferences() {
        for (CTPreferences ctPreferences : (List)this._ctPreferencesLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CTPreferencesTable.INSTANCE).from((Table)CTPreferencesTable.INSTANCE).where(CTPreferencesTable.INSTANCE.previousCtCollectionId.neq((Object)0L).or((Expression)CTPreferencesTable.INSTANCE.ctCollectionId.neq((Object)0L))))) {
            ctPreferences.setCtCollectionId(0L);
            ctPreferences.setPreviousCtCollectionId(0L);
            this._ctPreferencesLocalService.updateCTPreferences(ctPreferences);
        }
        for (CTCollection ctCollection : (List)this._ctCollectionLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CTCollectionTable.INSTANCE).from((Table)CTCollectionTable.INSTANCE).where(CTCollectionTable.INSTANCE.status.eq((Object)2)))) {
            ctCollection.setStatus(3);
            this._ctCollectionLocalService.updateCTCollection(ctCollection);
        }
    }
}

