/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.upgrade.v2_4_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

/**
 * @author Preston Crary
 */
public class CTSchemaVersionUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		runSQL("alter table CTCollection add schemaVersionId LONG");

		runSQL("update CTCollection set schemaVersionId = 0");

		runSQL(
			StringBundler.concat(
				"create table CTSchemaVersion (mvccVersion LONG default 0 not ",
				"null, schemaVersionId LONG not null primary key, companyId ",
				"LONG, schemaContext TEXT null)"));

		runSQL(
			StringBundler.concat(
				"update CTCollection set status = ",
				WorkflowConstants.STATUS_EXPIRED, " where status = ",
				WorkflowConstants.STATUS_DRAFT));

		runSQL(
			"update CTPreferences set ctCollectionId = 0, " +
				"previousCtCollectionId = 0");
	}

}