/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.spi.reference;

import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.change.tracking.spi.reference.builder.ChildTableReferenceInfoBuilder;
import com.liferay.change.tracking.spi.reference.builder.ParentTableReferenceInfoBuilder;
import com.liferay.portal.kernel.model.CompanyTable;
import com.liferay.portal.kernel.model.OrganizationTable;
import com.liferay.portal.kernel.model.PortalPreferencesTable;
import com.liferay.portal.kernel.model.UserTable;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.PortalPreferencesPersistence;
import com.liferay.portal.kernel.util.PortletKeys;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Preston Crary
 */
@Component(service = TableReferenceDefinition.class)
public class PortalPreferencesTableReferenceDefinition
	implements TableReferenceDefinition<PortalPreferencesTable> {

	@Override
	public void defineChildTableReferences(
		ChildTableReferenceInfoBuilder<PortalPreferencesTable>
			childTableReferenceInfoBuilder) {
	}

	@Override
	public void defineParentTableReferences(
		ParentTableReferenceInfoBuilder<PortalPreferencesTable>
			parentTableReferenceInfoBuilder) {

		parentTableReferenceInfoBuilder.referenceInnerJoin(
			fromStep -> fromStep.from(
				CompanyTable.INSTANCE
			).innerJoinON(
				PortalPreferencesTable.INSTANCE,
				PortalPreferencesTable.INSTANCE.ownerId.eq(
					CompanyTable.INSTANCE.companyId
				).and(
					PortalPreferencesTable.INSTANCE.ownerType.eq(
						PortletKeys.PREFS_OWNER_TYPE_COMPANY)
				)
			)
		).referenceInnerJoin(
			fromStep -> fromStep.from(
				OrganizationTable.INSTANCE
			).innerJoinON(
				PortalPreferencesTable.INSTANCE,
				PortalPreferencesTable.INSTANCE.ownerId.eq(
					OrganizationTable.INSTANCE.organizationId
				).and(
					PortalPreferencesTable.INSTANCE.ownerType.eq(
						PortletKeys.PREFS_OWNER_TYPE_ORGANIZATION)
				)
			)
		).referenceInnerJoin(
			fromStep -> fromStep.from(
				UserTable.INSTANCE
			).innerJoinON(
				PortalPreferencesTable.INSTANCE,
				PortalPreferencesTable.INSTANCE.ownerId.eq(
					UserTable.INSTANCE.userId
				).and(
					PortalPreferencesTable.INSTANCE.ownerType.eq(
						PortletKeys.PREFS_OWNER_TYPE_USER)
				)
			)
		);
	}

	@Override
	public BasePersistence<?> getBasePersistence() {
		return _portalPreferencesPersistence;
	}

	@Override
	public PortalPreferencesTable getTable() {
		return PortalPreferencesTable.INSTANCE;
	}

	@Reference
	private PortalPreferencesPersistence _portalPreferencesPersistence;

}