/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.search;

import com.liferay.change.tracking.constants.CTConstants;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;

import org.osgi.service.component.annotations.Component;

/**
 * @author Preston Crary
 * @author André de Oliveira
 */
@Component(immediate = true, service = DocumentContributor.class)
public class CTModelDocumentContributor implements DocumentContributor<Object> {

	@Override
	public void contribute(Document document, BaseModel<Object> baseModel) {
		if (!(baseModel instanceof CTModel)) {
			return;
		}

		CTModel<?> ctModel = (CTModel<?>)baseModel;

		if (ctModel.getCtCollectionId() !=
				CTConstants.CT_COLLECTION_ID_PRODUCTION) {

			document.addKeyword(_CT_COLLECTION_ID, ctModel.getCtCollectionId());
		}
	}

	private static final String _CT_COLLECTION_ID = "ctCollectionId";

}