/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.resolver;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;

import java.util.Arrays;

/**
 * @author Preston Crary
 */
public class ConstraintResolverKey {

	public ConstraintResolverKey(
		Class<?> modelClass, String[] uniqueIndexNames) {

		this(modelClass.getName(), uniqueIndexNames);
	}

	public ConstraintResolverKey(
		String modelClassName, String[] uniqueIndexNames) {

		_modelClassName = modelClassName;
		_uniqueIndexNames = uniqueIndexNames;
	}

	@Override
	public boolean equals(Object object) {
		ConstraintResolverKey constraintResolverKey =
			(ConstraintResolverKey)object;

		if (_modelClassName.equals(constraintResolverKey._modelClassName) &&
			Arrays.equals(
				_uniqueIndexNames, constraintResolverKey._uniqueIndexNames)) {

			return true;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int hash = HashUtil.hash(0, _modelClassName);

		for (String uniqueIndexName : _uniqueIndexNames) {
			hash = HashUtil.hash(hash, uniqueIndexName);
		}

		return hash;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(
			(_uniqueIndexNames.length * 2) + 2);

		sb.append("{modelClassName=");
		sb.append(_modelClassName);
		sb.append(", uniqueIndexNames=[");

		for (String uniqueIndexName : _uniqueIndexNames) {
			sb.append(uniqueIndexName);
			sb.append(", ");
		}

		sb.setStringAt("]}", sb.index() - 1);

		return sb.toString();
	}

	private final String _modelClassName;
	private final String[] _uniqueIndexNames;

}