/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.resolver;

import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.change.tracking.CTService;

/**
 * @author Preston Crary
 */
public class ConstraintResolverContextImpl<T extends CTModel<T>>
	implements ConstraintResolverContext<T> {

	public ConstraintResolverContextImpl(
		CTService<T> ctService, long sourceCTCollectionId,
		long targetCTCollectionId) {

		_ctService = ctService;
		_sourceCTCollectionId = sourceCTCollectionId;
		_targetCTCollectionId = targetCTCollectionId;
	}

	@Override
	public <R, E extends Throwable> R getInTarget(
			UnsafeSupplier<R, E> unsafeSupplier)
		throws E {

		try (SafeCloseable safeCloseable =
				CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable(
					_targetCTCollectionId)) {

			return unsafeSupplier.get();
		}
	}

	@Override
	public T getSourceCTModel() {
		return _ctService.updateWithUnsafeFunction(
			ctPersistence -> ctPersistence.fetchByPrimaryKey(
				_sourcePrimaryKey));
	}

	@Override
	public T getTargetCTModel() {
		try (SafeCloseable safeCloseable =
				CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable(
					_targetCTCollectionId)) {

			return _ctService.updateWithUnsafeFunction(
				ctPersistence -> ctPersistence.fetchByPrimaryKey(
					_targetPrimaryKey));
		}
	}

	@Override
	public boolean isSourceCTModel(CTModel<?> ctModel) {
		if (ctModel.getCtCollectionId() == _sourceCTCollectionId) {
			return true;
		}

		return false;
	}

	@Override
	public boolean isTargetCTModel(CTModel<?> ctModel) {
		if (ctModel.getCtCollectionId() == _targetCTCollectionId) {
			return true;
		}

		return false;
	}

	public void setPrimaryKeys(long sourcePrimaryKey, long targetPrimaryKey) {
		_sourcePrimaryKey = sourcePrimaryKey;
		_targetPrimaryKey = targetPrimaryKey;
	}

	private final CTService<T> _ctService;
	private final long _sourceCTCollectionId;
	private long _sourcePrimaryKey;
	private final long _targetCTCollectionId;
	private long _targetPrimaryKey;

}