/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.reference.builder;

import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.change.tracking.spi.reference.builder.ParentTableReferenceInfoBuilder;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.JoinStep;

import java.util.function.Function;

/**
 * @author Preston Crary
 */
public class ParentTableReferenceInfoBuilderImpl<T extends Table<T>>
	extends BaseTableReferenceInfoBuilder<T>
	implements ParentTableReferenceInfoBuilder<T> {

	public ParentTableReferenceInfoBuilderImpl(
		TableReferenceDefinition<T> tableReferenceDefinition,
		Column<T, Long> primaryKeyColumn) {

		super(tableReferenceDefinition, primaryKeyColumn, true);
	}

	@Override
	public ParentTableReferenceInfoBuilder<T> referenceInnerJoin(
		Function<FromStep, JoinStep> joinFunction) {

		applyReferenceInnerJoin(joinFunction);

		return this;
	}

}