/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.reference;

import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;

import java.util.Objects;

/**
 * @author Preston Crary
 */
public class TableUtil {

	@SuppressWarnings("unchecked")
	public static <T extends Table<T>> Column<T, Long> getPrimaryKeyColumn(
		Table<T> table) {

		for (Column<T, ?> column : table.getColumns()) {
			if (column.isPrimaryKey() &&
				!Objects.equals(column.getName(), "ctCollectionId") &&
				Long.class.isAssignableFrom(column.getJavaType())) {

				return (Column<T, Long>)column;
			}
		}

		return null;
	}

}