/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.reference;

import com.liferay.change.tracking.internal.reference.builder.ChildTableReferenceInfoBuilderImpl;
import com.liferay.change.tracking.internal.reference.builder.ParentTableReferenceInfoBuilderImpl;
import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;

/**
 * @author Preston Crary
 */
public class TableReferenceInfoFactory {

	public static <T extends Table<T>> TableReferenceInfo<T> create(
		long classNameId, Column<T, Long> primaryKeyColumn,
		TableReferenceDefinition<T> tableReferenceDefinition) {

		ParentTableReferenceInfoBuilderImpl<T>
			parentTableReferenceInfoBuilderImpl =
				new ParentTableReferenceInfoBuilderImpl<>(
					tableReferenceDefinition, primaryKeyColumn);

		tableReferenceDefinition.defineParentTableReferences(
			parentTableReferenceInfoBuilderImpl);

		ChildTableReferenceInfoBuilderImpl<T>
			childTableReferenceInfoBuilderImpl =
				new ChildTableReferenceInfoBuilderImpl<>(
					tableReferenceDefinition, primaryKeyColumn);

		tableReferenceDefinition.defineChildTableReferences(
			childTableReferenceInfoBuilderImpl);

		TableReferenceAppenderRegistry.appendTableReferences(
			tableReferenceDefinition, primaryKeyColumn,
			parentTableReferenceInfoBuilderImpl,
			childTableReferenceInfoBuilderImpl);

		return new TableReferenceInfo<>(
			childTableReferenceInfoBuilderImpl.getTableJoinHoldersMap(),
			classNameId,
			parentTableReferenceInfoBuilderImpl.getTableJoinHoldersMap(),
			tableReferenceDefinition);
	}

}