/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.reference;

import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.petra.sql.dsl.Table;

import java.util.List;
import java.util.Map;

/**
 * @author Preston Crary
 */
public class TableReferenceInfo<T extends Table<T>> {

	public TableReferenceInfo(
		Map<Table<?>, List<TableJoinHolder>> childTableJoinHoldersMap,
		long classNameId,
		Map<Table<?>, List<TableJoinHolder>> parentTableJoinHoldersMap,
		TableReferenceDefinition<T> tableReferenceDefinition) {

		_childTableJoinHoldersMap = childTableJoinHoldersMap;
		_classNameId = classNameId;
		_parentTableJoinHoldersMap = parentTableJoinHoldersMap;
		_tableReferenceDefinition = tableReferenceDefinition;
	}

	public Map<Table<?>, List<TableJoinHolder>> getChildTableJoinHoldersMap() {
		return _childTableJoinHoldersMap;
	}

	public long getClassNameId() {
		return _classNameId;
	}

	public Map<Table<?>, List<TableJoinHolder>> getParentTableJoinHoldersMap() {
		return _parentTableJoinHoldersMap;
	}

	public TableReferenceDefinition<T> getTableReferenceDefinition() {
		return _tableReferenceDefinition;
	}

	private final Map<Table<?>, List<TableJoinHolder>>
		_childTableJoinHoldersMap;
	private final long _classNameId;
	private final Map<Table<?>, List<TableJoinHolder>>
		_parentTableJoinHoldersMap;
	private final TableReferenceDefinition<T> _tableReferenceDefinition;

}