/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.reference;

import com.liferay.change.tracking.internal.spi.reference.ExpandoTableReferenceAppender;
import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.change.tracking.spi.reference.builder.ChildTableReferenceInfoBuilder;
import com.liferay.change.tracking.spi.reference.builder.ParentTableReferenceInfoBuilder;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.BasePersistence;

import java.util.Collections;
import java.util.List;

/**
 * @author Preston Crary
 */
public class TableReferenceAppenderRegistry {

	public static <T extends Table<T>> void appendTableReferences(
		TableReferenceDefinition<T> tableReferenceDefinition,
		Column<T, Long> primaryKeyColumn,
		ParentTableReferenceInfoBuilder<T> parentTableReferenceInfoBuilder,
		ChildTableReferenceInfoBuilder<T> childTableReferenceInfoBuilder) {

		BasePersistence<?> basePersistence =
			tableReferenceDefinition.getBasePersistence();

		Class<? extends BaseModel<?>> modelClass =
			basePersistence.getModelClass();

		for (TableReferenceAppender tableReferenceAppender :
				_tableReferenceAppenders) {

			tableReferenceAppender.appendParentTableReferences(
				modelClass, primaryKeyColumn, parentTableReferenceInfoBuilder);

			tableReferenceAppender.appendChildTableReferences(
				modelClass, primaryKeyColumn, childTableReferenceInfoBuilder);
		}
	}

	private static final List<TableReferenceAppender> _tableReferenceAppenders =
		Collections.singletonList(new ExpandoTableReferenceAppender());

}