/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.reference;

import com.liferay.change.tracking.spi.reference.builder.ChildTableReferenceInfoBuilder;
import com.liferay.change.tracking.spi.reference.builder.ParentTableReferenceInfoBuilder;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.model.BaseModel;

/**
 * @author Preston Crary
 */
public interface TableReferenceAppender {

	public <T extends Table<T>> void appendChildTableReferences(
		Class<? extends BaseModel<?>> modelClass,
		Column<T, Long> primaryKeyColumn,
		ChildTableReferenceInfoBuilder<T> childTableReferenceInfoBuilder);

	public <T extends Table<T>> void appendParentTableReferences(
		Class<? extends BaseModel<?>> modelClass,
		Column<T, Long> primaryKeyColumn,
		ParentTableReferenceInfoBuilder<T> parentTableReferenceInfoBuilder);

}