/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.model.listener;

import com.liferay.change.tracking.internal.background.task.CTPublishBackgroundTaskExecutor;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTSchemaVersionLocalService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.constants.BackgroundTaskConstants;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.util.Objects;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Preston Crary
 */
@Component(immediate = true, service = ModelListener.class)
public class BackgroundTaskModelListener
	extends BaseModelListener<BackgroundTask> {

	@Override
	public void onAfterUpdate(
		BackgroundTask originalBackgroundTask, BackgroundTask backgroundTask) {

		if ((backgroundTask != null) &&
			Objects.equals(
				backgroundTask.getTaskExecutorClassName(),
				CTPublishBackgroundTaskExecutor.class.getName()) &&
			((backgroundTask.getStatus() ==
				BackgroundTaskConstants.STATUS_CANCELLED) ||
			 (backgroundTask.getStatus() ==
				 BackgroundTaskConstants.STATUS_FAILED))) {

			CTCollection ctCollection =
				_ctCollectionLocalService.fetchCTCollection(
					Long.valueOf(backgroundTask.getName()));

			if (ctCollection != null) {
				int status = WorkflowConstants.STATUS_DRAFT;

				if (!_ctSchemaVersionLocalService.isLatestCTSchemaVersion(
						ctCollection.getSchemaVersionId())) {

					status = WorkflowConstants.STATUS_EXPIRED;
				}

				ctCollection.setStatus(status);

				_ctCollectionLocalService.updateCTCollection(ctCollection);
			}
		}
	}

	@Reference
	private CTCollectionLocalService _ctCollectionLocalService;

	@Reference
	private CTSchemaVersionLocalService _ctSchemaVersionLocalService;

}