/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.conflict;

import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * @author Preston Crary
 */
public class MissingRequirementConflictInfo extends BaseConflictInfo {

	public MissingRequirementConflictInfo(
		String className, long modelClassPK,
		CTDisplayRenderer<?> requirementCTDisplayRenderer) {

		_className = className;
		_modelClassPK = modelClassPK;
		_requirementCTDisplayRenderer = requirementCTDisplayRenderer;
	}

	@Override
	public String getConflictDescription(ResourceBundle resourceBundle) {
		return LanguageUtil.get(resourceBundle, "missing-requirement-conflict");
	}

	@Override
	public String getResolutionDescription(ResourceBundle resourceBundle) {
		return LanguageUtil.format(
			resourceBundle,
			"cannot-be-added-because-a-required-x-has-been-deleted",
			_getRequirementTypeName(resourceBundle.getLocale()), false);
	}

	@Override
	public long getSourcePrimaryKey() {
		return _modelClassPK;
	}

	@Override
	public long getTargetPrimaryKey() {
		return 0;
	}

	private String _getRequirementTypeName(Locale locale) {
		if (_requirementCTDisplayRenderer == null) {
			String name = ResourceActionsUtil.getModelResource(
				locale, _className);

			if (name.startsWith("model.resource.")) {
				return _className;
			}

			return name;
		}

		return _requirementCTDisplayRenderer.getTypeName(locale);
	}

	private final String _className;
	private final long _modelClassPK;
	private final CTDisplayRenderer<?> _requirementCTDisplayRenderer;

}