/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal.conflict;

import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * @author Preston Crary
 */
public abstract class BaseConflictInfo implements ConflictInfo {

	@Override
	public long getCTAutoResolutionInfoId() {
		return 0;
	}

	@Override
	public ResourceBundle getResourceBundle(Locale locale) {
		return ResourceBundleUtil.getBundle(locale, BaseConflictInfo.class);
	}

	@Override
	public boolean isResolved() {
		return false;
	}

	@Override
	public String toString() {
		return StringBundler.concat(
			"{conflict description=",
			getConflictDescription(getResourceBundle(LocaleUtil.getDefault())),
			", resolved=", isResolved(), ", sourcePrimaryKey=",
			getSourcePrimaryKey(), ", targetPrimaryKey=", getTargetPrimaryKey(),
			"}");
	}

}