/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;

import java.sql.Connection;

import java.util.Map;

/**
 * @author Preston Crary
 */
public class CTServiceCopier<T extends CTModel<T>> {

	public CTServiceCopier(
		CTService<T> ctService, long sourceCTCollectionId,
		long targetCTCollectionId) {

		_ctService = ctService;
		_sourceCTCollectionId = sourceCTCollectionId;
		_targetCTCollectionId = targetCTCollectionId;
	}

	public void copy() throws Exception {
		_ctService.updateWithUnsafeFunction(this::_copy);
	}

	private Void _copy(CTPersistence<T> ctPersistence) throws Exception {
		Connection connection = CurrentConnectionUtil.getConnection(
			ctPersistence.getDataSource());

		Map<String, Integer> tableColumnsMap =
			ctPersistence.getTableColumnsMap();

		StringBundler sb = new StringBundler((3 * tableColumnsMap.size()) + 5);

		sb.append("select ");

		for (String name : tableColumnsMap.keySet()) {
			if (name.equals("ctCollectionId")) {
				sb.append(_targetCTCollectionId);
				sb.append(" as ");
			}
			else {
				sb.append("t1.");
			}

			sb.append(name);
			sb.append(", ");
		}

		sb.setStringAt(" from ", sb.index() - 1);

		sb.append(ctPersistence.getTableName());
		sb.append(" t1 where t1.ctCollectionId = ");
		sb.append(_sourceCTCollectionId);

		CTRowUtil.copyCTRows(ctPersistence, connection, sb.toString());

		return null;
	}

	private final CTService<T> _ctService;
	private final long _sourceCTCollectionId;
	private final long _targetCTCollectionId;

}