/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.change.tracking.internal;

import com.liferay.change.tracking.constants.CTConstants;
import com.liferay.change.tracking.model.CTPreferences;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.portal.kernel.change.tracking.CTCollectionIdSupplier;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Preston Crary
 */
@Component(immediate = true, service = CTCollectionIdSupplier.class)
public class CTCollectionIdSupplierImpl implements CTCollectionIdSupplier {

	@Override
	public long getCTCollectionId() {
		CTPreferences ctPreferences =
			_ctPreferencesLocalService.fetchCTPreferences(
				CompanyThreadLocal.getCompanyId(),
				PrincipalThreadLocal.getUserId());

		if (ctPreferences == null) {
			return CTConstants.CT_COLLECTION_ID_PRODUCTION;
		}

		return ctPreferences.getCtCollectionId();
	}

	@Reference
	private CTPreferencesLocalService _ctPreferencesLocalService;

}