/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.model.impl;

import com.liferay.change.tracking.model.CTRemote;
import com.liferay.change.tracking.model.CTRemoteModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CTRemote service. Represents a row in the &quot;CTRemote&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CTRemoteModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CTRemoteImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTRemoteImpl
 * @generated
 */
@JSON(strict = true)
public class CTRemoteModelImpl
	extends BaseModelImpl<CTRemote> implements CTRemoteModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ct remote model instance should use the <code>CTRemote</code> interface instead.
	 */
	public static final String TABLE_NAME = "CTRemote";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctRemoteId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"name", Types.VARCHAR}, {"description", Types.VARCHAR},
		{"url", Types.VARCHAR}, {"clientId", Types.VARCHAR},
		{"clientSecret", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctRemoteId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("url", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("clientId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("clientSecret", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CTRemote (mvccVersion LONG default 0 not null,ctRemoteId LONG not null primary key,companyId LONG,userId LONG,createDate DATE null,modifiedDate DATE null,name VARCHAR(75) null,description VARCHAR(75) null,url VARCHAR(75) null,clientId VARCHAR(75) null,clientSecret VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table CTRemote";

	public static final String ORDER_BY_JPQL =
		" ORDER BY ctRemote.createDate ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CTRemote.createDate ASC";

	public static final String ORDER_BY_SQL_INLINE_DISTINCT =
		" ORDER BY ctRemote.createDate ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CTRemoteModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _ctRemoteId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCtRemoteId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _ctRemoteId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CTRemote.class;
	}

	@Override
	public String getModelClassName() {
		return CTRemote.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CTRemote, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CTRemote, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CTRemote, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((CTRemote)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CTRemote, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CTRemote, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CTRemote)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CTRemote, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CTRemote, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<CTRemote, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<CTRemote, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<CTRemote, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", CTRemote::getMvccVersion);
			attributeGetterFunctions.put("ctRemoteId", CTRemote::getCtRemoteId);
			attributeGetterFunctions.put("companyId", CTRemote::getCompanyId);
			attributeGetterFunctions.put("userId", CTRemote::getUserId);
			attributeGetterFunctions.put("createDate", CTRemote::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", CTRemote::getModifiedDate);
			attributeGetterFunctions.put("name", CTRemote::getName);
			attributeGetterFunctions.put(
				"description", CTRemote::getDescription);
			attributeGetterFunctions.put("url", CTRemote::getUrl);
			attributeGetterFunctions.put("clientId", CTRemote::getClientId);
			attributeGetterFunctions.put(
				"clientSecret", CTRemote::getClientSecret);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<CTRemote, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<CTRemote, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CTRemote, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<CTRemote, Long>)CTRemote::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctRemoteId",
				(BiConsumer<CTRemote, Long>)CTRemote::setCtRemoteId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<CTRemote, Long>)CTRemote::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId", (BiConsumer<CTRemote, Long>)CTRemote::setUserId);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<CTRemote, Date>)CTRemote::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<CTRemote, Date>)CTRemote::setModifiedDate);
			attributeSetterBiConsumers.put(
				"name", (BiConsumer<CTRemote, String>)CTRemote::setName);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<CTRemote, String>)CTRemote::setDescription);
			attributeSetterBiConsumers.put(
				"url", (BiConsumer<CTRemote, String>)CTRemote::setUrl);
			attributeSetterBiConsumers.put(
				"clientId",
				(BiConsumer<CTRemote, String>)CTRemote::setClientId);
			attributeSetterBiConsumers.put(
				"clientSecret",
				(BiConsumer<CTRemote, String>)CTRemote::setClientSecret);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtRemoteId() {
		return _ctRemoteId;
	}

	@Override
	public void setCtRemoteId(long ctRemoteId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctRemoteId = ctRemoteId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getUrl() {
		if (_url == null) {
			return "";
		}
		else {
			return _url;
		}
	}

	@Override
	public void setUrl(String url) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_url = url;
	}

	@JSON
	@Override
	public String getClientId() {
		if (_clientId == null) {
			return "";
		}
		else {
			return _clientId;
		}
	}

	@Override
	public void setClientId(String clientId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_clientId = clientId;
	}

	@JSON
	@Override
	public String getClientSecret() {
		if (_clientSecret == null) {
			return "";
		}
		else {
			return _clientSecret;
		}
	}

	@Override
	public void setClientSecret(String clientSecret) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_clientSecret = clientSecret;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CTRemote.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CTRemote toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CTRemote>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CTRemoteImpl ctRemoteImpl = new CTRemoteImpl();

		ctRemoteImpl.setMvccVersion(getMvccVersion());
		ctRemoteImpl.setCtRemoteId(getCtRemoteId());
		ctRemoteImpl.setCompanyId(getCompanyId());
		ctRemoteImpl.setUserId(getUserId());
		ctRemoteImpl.setCreateDate(getCreateDate());
		ctRemoteImpl.setModifiedDate(getModifiedDate());
		ctRemoteImpl.setName(getName());
		ctRemoteImpl.setDescription(getDescription());
		ctRemoteImpl.setUrl(getUrl());
		ctRemoteImpl.setClientId(getClientId());
		ctRemoteImpl.setClientSecret(getClientSecret());

		ctRemoteImpl.resetOriginalValues();

		return ctRemoteImpl;
	}

	@Override
	public CTRemote cloneWithOriginalValues() {
		CTRemoteImpl ctRemoteImpl = new CTRemoteImpl();

		ctRemoteImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		ctRemoteImpl.setCtRemoteId(
			this.<Long>getColumnOriginalValue("ctRemoteId"));
		ctRemoteImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		ctRemoteImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		ctRemoteImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		ctRemoteImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		ctRemoteImpl.setName(this.<String>getColumnOriginalValue("name"));
		ctRemoteImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		ctRemoteImpl.setUrl(this.<String>getColumnOriginalValue("url"));
		ctRemoteImpl.setClientId(
			this.<String>getColumnOriginalValue("clientId"));
		ctRemoteImpl.setClientSecret(
			this.<String>getColumnOriginalValue("clientSecret"));

		return ctRemoteImpl;
	}

	@Override
	public int compareTo(CTRemote ctRemote) {
		int value = 0;

		value = DateUtil.compareTo(getCreateDate(), ctRemote.getCreateDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CTRemote)) {
			return false;
		}

		CTRemote ctRemote = (CTRemote)object;

		long primaryKey = ctRemote.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CTRemote> toCacheModel() {
		CTRemoteCacheModel ctRemoteCacheModel = new CTRemoteCacheModel();

		ctRemoteCacheModel.mvccVersion = getMvccVersion();

		ctRemoteCacheModel.ctRemoteId = getCtRemoteId();

		ctRemoteCacheModel.companyId = getCompanyId();

		ctRemoteCacheModel.userId = getUserId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			ctRemoteCacheModel.createDate = createDate.getTime();
		}
		else {
			ctRemoteCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			ctRemoteCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			ctRemoteCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		ctRemoteCacheModel.name = getName();

		String name = ctRemoteCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			ctRemoteCacheModel.name = null;
		}

		ctRemoteCacheModel.description = getDescription();

		String description = ctRemoteCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			ctRemoteCacheModel.description = null;
		}

		ctRemoteCacheModel.url = getUrl();

		String url = ctRemoteCacheModel.url;

		if ((url != null) && (url.length() == 0)) {
			ctRemoteCacheModel.url = null;
		}

		ctRemoteCacheModel.clientId = getClientId();

		String clientId = ctRemoteCacheModel.clientId;

		if ((clientId != null) && (clientId.length() == 0)) {
			ctRemoteCacheModel.clientId = null;
		}

		ctRemoteCacheModel.clientSecret = getClientSecret();

		String clientSecret = ctRemoteCacheModel.clientSecret;

		if ((clientSecret != null) && (clientSecret.length() == 0)) {
			ctRemoteCacheModel.clientSecret = null;
		}

		return ctRemoteCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CTRemote, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CTRemote, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CTRemote, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((CTRemote)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CTRemote>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CTRemote.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctRemoteId;
	private long _companyId;
	private long _userId;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _name;
	private String _description;
	private String _url;
	private String _clientId;
	private String _clientSecret;

	public <T> T getColumnValue(String columnName) {
		Function<CTRemote, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CTRemote)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctRemoteId", _ctRemoteId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("url", _url);
		_columnOriginalValues.put("clientId", _clientId);
		_columnOriginalValues.put("clientSecret", _clientSecret);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctRemoteId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("createDate", 16L);

		columnBitmasks.put("modifiedDate", 32L);

		columnBitmasks.put("name", 64L);

		columnBitmasks.put("description", 128L);

		columnBitmasks.put("url", 256L);

		columnBitmasks.put("clientId", 512L);

		columnBitmasks.put("clientSecret", 1024L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CTRemote _escapedModel;

}