/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.score;

import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.store.model.CTSContent;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTScoreCalculator.class})
public class CTScoreCalculator {
    private static final int _COUNT_DIVISOR = 50000000;
    private static final Log _log = LogFactoryUtil.getLog(CTScoreCalculator.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private MultiVMPool _multiVMPool;
    private PortalCache<Long, Integer> _portalCache;

    public int calculate(long modelClassNameId) {
        Integer score = (Integer)this._portalCache.get((Serializable)Long.valueOf(modelClassNameId));
        if (score != null) {
            return score;
        }
        score = 4;
        if (modelClassNameId == this._classNameLocalService.getClassNameId(CTSContent.class)) {
            score = score + 20;
        } else if (modelClassNameId == this._classNameLocalService.getClassNameId(JournalArticle.class)) {
            Integer n = score;
            score = score + 1;
        }
        int countMultiplier = this._countTable(modelClassNameId) / 50000000;
        if (countMultiplier == 0) {
            countMultiplier = 1;
        }
        score = score * countMultiplier;
        DB db = DBManagerUtil.getDB();
        DBType dbType = db.getDBType();
        if (dbType.equals((Object)DBType.ORACLE) || dbType.equals((Object)DBType.SQLSERVER)) {
            score = score * 2;
        }
        this._portalCache.put((Serializable)Long.valueOf(modelClassNameId), (Object)score);
        return score;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._portalCache = this._multiVMPool.getPortalCache(CTScoreCalculator.class.getName());
    }

    @Deactivate
    protected void deactivate() {
        this._portalCache.removeAll();
    }

    private int _countTable(long modelClassNameId) {
        CTService<?> ctService = this._ctServiceRegistry.getCTService(modelClassNameId);
        if (ctService == null) {
            return 0;
        }
        return (Integer)ctService.updateWithUnsafeFunction(ctPersistence -> {
            Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
            if (primaryKeyNames.size() != 1) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", ctPersistence.getTableName(), "}"}));
            }
            Iterator iterator = primaryKeyNames.iterator();
            String primaryKeyName = (String)iterator.next();
            Connection connection = this._currentConnection.getConnection(ctPersistence.getDataSource());
            try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select count(", primaryKeyName, ") from ", ctPersistence.getTableName()}));){
                Integer n;
                block20: {
                    ResultSet resultSet;
                    block18: {
                        Integer n2;
                        block19: {
                            resultSet = preparedStatement.executeQuery();
                            try {
                                if (!resultSet.next()) break block18;
                                n2 = resultSet.getInt(1);
                                if (resultSet == null) break block19;
                            }
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            resultSet.close();
                        }
                        return n2;
                    }
                    n = 0;
                    if (resultSet == null) break block20;
                    resultSet.close();
                }
                return n;
            }
            catch (SQLException sqlException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)sqlException);
                }
                return 0;
            }
        });
    }
}

