/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.model.listener;

import com.liferay.change.tracking.closure.CTClosureFactory;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CTEntryModelListener
extends BaseModelListener<CTEntry> {
    @Reference
    private CTClosureFactory _ctClosureFactory;
    @Reference
    private MessageBus _messageBus;

    public void onAfterCreate(CTEntry ctEntry) {
        this._ctClosureFactory.clearCache(ctEntry.getCtCollectionId());
        this._reindexCTEntry(ctEntry, "reindex");
        this._updateCTScore(ctEntry, true);
    }

    public void onAfterRemove(CTEntry ctEntry) {
        this._ctClosureFactory.clearCache(ctEntry.getCtCollectionId());
        this._reindexCTEntry(ctEntry, "delete");
        this._updateCTScore(ctEntry, false);
    }

    public void onAfterUpdate(CTEntry originalCTEntry, CTEntry ctEntry) throws ModelListenerException {
        if (originalCTEntry.getCtCollectionId() != ctEntry.getCtCollectionId()) {
            this._ctClosureFactory.clearCache(originalCTEntry.getCtCollectionId());
            this._updateCTScore(originalCTEntry, false);
            this._updateCTScore(ctEntry, true);
        }
        if (originalCTEntry.getCtCollectionId() != ctEntry.getCtCollectionId() || originalCTEntry.getUserId() != ctEntry.getUserId()) {
            this._reindexCTEntry(ctEntry, "reindex");
        }
        this._ctClosureFactory.clearCache(ctEntry.getCtCollectionId());
    }

    private void _reindexCTEntry(CTEntry ctEntry, String type) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.setValues((Map)HashMapBuilder.put((Object)"companyId", (Object)ctEntry.getCompanyId()).put((Object)"ctEntryId", (Object)ctEntry.getCtEntryId()).put((Object)"type", (Object)type).build());
            this._messageBus.sendMessage("liferay/ct_entry_reindex", message);
            return null;
        });
    }

    private void _updateCTScore(CTEntry ctEntry, boolean increment) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.setValues((Map)HashMapBuilder.put((Object)"ctCollectionId", (Object)ctEntry.getCtCollectionId()).put((Object)"increment", (Object)increment).put((Object)"modelClassNameId", (Object)ctEntry.getModelClassNameId()).build());
            this._messageBus.sendMessage("liferay/ct_score", message);
            return null;
        });
    }
}

