/**
 * SPDX-FileCopyrightText: (c) 2024 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.model.impl;

import com.liferay.change.tracking.model.CTScore;
import com.liferay.change.tracking.service.CTScoreLocalServiceUtil;

/**
 * The extended model base implementation for the CTScore service. Represents a row in the &quot;CTScore&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CTScoreImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTScoreImpl
 * @see CTScore
 * @generated
 */
public abstract class CTScoreBaseImpl
	extends CTScoreModelImpl implements CTScore {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ct score model instance should use the <code>CTScore</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CTScoreLocalServiceUtil.addCTScore(this);
		}
		else {
			CTScoreLocalServiceUtil.updateCTScore(this);
		}
	}

}