/**
 * SPDX-FileCopyrightText: (c) 2024 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.model.impl;

import com.liferay.change.tracking.model.CTScore;
import com.liferay.change.tracking.model.CTScoreModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CTScore service. Represents a row in the &quot;CTScore&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CTScoreModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CTScoreImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTScoreImpl
 * @generated
 */
public class CTScoreModelImpl
	extends BaseModelImpl<CTScore> implements CTScoreModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ct score model instance should use the <code>CTScore</code> interface instead.
	 */
	public static final String TABLE_NAME = "CTScore";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctScoreId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"score", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctScoreId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("score", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CTScore (mvccVersion LONG default 0 not null,ctScoreId LONG not null primary key,companyId LONG,ctCollectionId LONG,score INTEGER)";

	public static final String TABLE_SQL_DROP = "drop table CTScore";

	public static final String ORDER_BY_JPQL =
		" ORDER BY ctScore.ctScoreId ASC";

	public static final String ORDER_BY_SQL = " ORDER BY CTScore.ctScoreId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CTCOLLECTIONID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CTSCOREID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CTScoreModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _ctScoreId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCtScoreId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _ctScoreId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CTScore.class;
	}

	@Override
	public String getModelClassName() {
		return CTScore.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CTScore, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CTScore, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CTScore, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((CTScore)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CTScore, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CTScore, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CTScore)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CTScore, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CTScore, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<CTScore, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<CTScore, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<CTScore, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", CTScore::getMvccVersion);
			attributeGetterFunctions.put("ctScoreId", CTScore::getCtScoreId);
			attributeGetterFunctions.put("companyId", CTScore::getCompanyId);
			attributeGetterFunctions.put(
				"ctCollectionId", CTScore::getCtCollectionId);
			attributeGetterFunctions.put("score", CTScore::getScore);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<CTScore, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<CTScore, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CTScore, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<CTScore, Long>)CTScore::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctScoreId", (BiConsumer<CTScore, Long>)CTScore::setCtScoreId);
			attributeSetterBiConsumers.put(
				"companyId", (BiConsumer<CTScore, Long>)CTScore::setCompanyId);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<CTScore, Long>)CTScore::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"score", (BiConsumer<CTScore, Integer>)CTScore::setScore);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtScoreId() {
		return _ctScoreId;
	}

	@Override
	public void setCtScoreId(long ctScoreId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctScoreId = ctScoreId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCtCollectionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
	}

	@Override
	public int getScore() {
		return _score;
	}

	@Override
	public void setScore(int score) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_score = score;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CTScore.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CTScore toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CTScore>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CTScoreImpl ctScoreImpl = new CTScoreImpl();

		ctScoreImpl.setMvccVersion(getMvccVersion());
		ctScoreImpl.setCtScoreId(getCtScoreId());
		ctScoreImpl.setCompanyId(getCompanyId());
		ctScoreImpl.setCtCollectionId(getCtCollectionId());
		ctScoreImpl.setScore(getScore());

		ctScoreImpl.resetOriginalValues();

		return ctScoreImpl;
	}

	@Override
	public CTScore cloneWithOriginalValues() {
		CTScoreImpl ctScoreImpl = new CTScoreImpl();

		ctScoreImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		ctScoreImpl.setCtScoreId(
			this.<Long>getColumnOriginalValue("ctScoreId"));
		ctScoreImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		ctScoreImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		ctScoreImpl.setScore(this.<Integer>getColumnOriginalValue("score"));

		return ctScoreImpl;
	}

	@Override
	public int compareTo(CTScore ctScore) {
		long primaryKey = ctScore.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CTScore)) {
			return false;
		}

		CTScore ctScore = (CTScore)object;

		long primaryKey = ctScore.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CTScore> toCacheModel() {
		CTScoreCacheModel ctScoreCacheModel = new CTScoreCacheModel();

		ctScoreCacheModel.mvccVersion = getMvccVersion();

		ctScoreCacheModel.ctScoreId = getCtScoreId();

		ctScoreCacheModel.companyId = getCompanyId();

		ctScoreCacheModel.ctCollectionId = getCtCollectionId();

		ctScoreCacheModel.score = getScore();

		return ctScoreCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CTScore, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CTScore, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CTScore, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((CTScore)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CTScore>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CTScore.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctScoreId;
	private long _companyId;
	private long _ctCollectionId;
	private int _score;

	public <T> T getColumnValue(String columnName) {
		Function<CTScore, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CTScore)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctScoreId", _ctScoreId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("score", _score);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctScoreId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("ctCollectionId", 8L);

		columnBitmasks.put("score", 16L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CTScore _escapedModel;

}