/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTEntryModel;
import com.liferay.change.tracking.model.CTEntryTable;
import com.liferay.change.tracking.service.base.CTEntryLocalServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTCollectionPersistence;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@CTAware
@Component(property={"model.class.name=com.liferay.change.tracking.model.CTEntry"}, service={AopService.class})
public class CTEntryLocalServiceImpl
extends CTEntryLocalServiceBaseImpl {
    @Reference
    private CTCollectionPersistence _ctCollectionPersistence;

    @Indexable(type=IndexableType.REINDEX)
    public CTEntry addCTEntry(String externalReferenceCode, long ctCollectionId, long modelClassNameId, CTModel<?> ctModel, long userId, int changeType) throws PortalException {
        CTCollection ctCollection = this._ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        if (ctCollection.isReadOnly()) {
            throw new PortalException("Change tracking collection " + String.valueOf(ctCollection) + " is read only");
        }
        long ctEntryId = this.counterLocalService.increment(CTEntry.class.getName());
        CTEntry ctEntry = this.ctEntryPersistence.create(ctEntryId);
        ctEntry.setExternalReferenceCode(externalReferenceCode);
        ctEntry.setCompanyId(ctCollection.getCompanyId());
        ctEntry.setUserId(userId);
        ctEntry.setCtCollectionId(ctCollectionId);
        ctEntry.setModelClassNameId(modelClassNameId);
        ctEntry.setModelClassPK(ctModel.getPrimaryKey());
        ctEntry.setModelMvccVersion(ctModel.getMvccVersion());
        ctEntry.setChangeType(changeType);
        return (CTEntry)this.ctEntryPersistence.update((BaseModel)ctEntry);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CTEntry deleteCTEntry(CTEntry ctEntry) throws PortalException {
        return this.deleteCTEntry(ctEntry, false);
    }

    @Indexable(type=IndexableType.DELETE)
    public CTEntry deleteCTEntry(CTEntry ctEntry, boolean force) throws PortalException {
        CTCollection ctCollection = this._ctCollectionPersistence.findByPrimaryKey(ctEntry.getCtCollectionId());
        if (!force && ctCollection.isReadOnly()) {
            throw new PortalException("Change tracking collection " + String.valueOf(ctCollection) + " is read only");
        }
        return (CTEntry)this.ctEntryPersistence.remove((BaseModel)ctEntry);
    }

    public CTEntry fetchCTEntry(long ctCollectionId, long modelClassNameId, long modelClassPK) {
        return this.ctEntryPersistence.fetchByC_MCNI_MCPK(ctCollectionId, modelClassNameId, modelClassPK);
    }

    public List<CTEntry> getCTCollectionCTEntries(long ctCollectionId) {
        return this.getCTCollectionCTEntries(ctCollectionId, -1, -1, null);
    }

    public List<CTEntry> getCTCollectionCTEntries(long ctCollectionId, int start, int end, OrderByComparator<CTEntry> orderByComparator) {
        if (ctCollectionId == 0L) {
            return Collections.emptyList();
        }
        return this.ctEntryPersistence.findByCtCollectionId(ctCollectionId, start, end, orderByComparator);
    }

    public int getCTCollectionCTEntriesCount(long ctCollectionId) {
        if (ctCollectionId == 0L) {
            return 0;
        }
        return this.ctEntryPersistence.countByCtCollectionId(ctCollectionId);
    }

    public List<CTEntry> getCTEntries(long ctCollectionId, long modelClassNameId) {
        return this.ctEntryPersistence.findByC_MCNI(ctCollectionId, modelClassNameId);
    }

    public List<CTEntry> getCTEntries(long[] ctEntryIds) {
        HashSet primaryKeys = new HashSet(TransformUtil.transformToList((long[])ctEntryIds, GetterUtil::getLong));
        Map ctEntriesMap = this.ctEntryPersistence.fetchByPrimaryKeys(primaryKeys);
        return new ArrayList<CTEntry>(ctEntriesMap.values());
    }

    public long getCTRowCTCollectionId(CTEntry ctEntry) throws PortalException {
        CTCollection ctCollection = this._ctCollectionPersistence.findByPrimaryKey(ctEntry.getCtCollectionId());
        if (ctCollection.getStatus() == 2 || ctCollection.getStatus() == 1) {
            return ctCollection.getCtCollectionId();
        }
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{CTEntryTable.INSTANCE.ctCollectionId}).from((Table)CTEntryTable.INSTANCE).innerJoinON((Table)CTCollectionTable.INSTANCE, CTCollectionTable.INSTANCE.ctCollectionId.eq((Expression)CTEntryTable.INSTANCE.ctCollectionId).and((Expression)CTCollectionTable.INSTANCE.status.eq((Object)0))).where(CTEntryTable.INSTANCE.modelClassNameId.eq((Object)ctEntry.getModelClassNameId()).and((Expression)CTEntryTable.INSTANCE.modelClassPK.eq((Object)ctEntry.getModelClassPK())).and((Expression)CTCollectionTable.INSTANCE.statusDate.gt((Object)ctCollection.getStatusDate()))).orderBy(new OrderByExpression[]{CTCollectionTable.INSTANCE.statusDate.ascending()}).limit(0, 1);
        List ctCollectionIds = (List)this.ctEntryPersistence.dslQuery(dslQuery);
        if (ctCollectionIds.isEmpty()) {
            return 0L;
        }
        return (Long)ctCollectionIds.get(0);
    }

    public List<Long> getExclusiveModelClassPKs(long ctCollectionId, long modelClassNameId) {
        List ctEntries = this.ctEntryPersistence.findByC_MCNI(ctCollectionId, modelClassNameId);
        if (ctEntries.isEmpty()) {
            return Collections.emptyList();
        }
        List modelClassPKs = ListUtil.toList((List)ctEntries, CTEntryModel::getModelClassPK);
        for (CTEntry ctEntry : this.ctEntryPersistence.findByNotC_MCNI_MCPK(ctCollectionId, modelClassNameId, ArrayUtil.toArray((Long[])modelClassPKs.toArray(new Long[0])))) {
            modelClassPKs.remove(ctEntry.getModelClassPK());
        }
        return modelClassPKs;
    }

    public boolean hasCTEntries(long ctCollectionId, long modelClassNameId) {
        int count = this.ctEntryPersistence.countByC_MCNI(ctCollectionId, modelClassNameId);
        return count != 0;
    }

    public boolean hasCTEntry(long ctCollectionId, long modelClassNameId, long modelClassPK) {
        int count = this.ctEntryPersistence.countByC_MCNI_MCPK(ctCollectionId, modelClassNameId, modelClassPK);
        return count != 0;
    }

    public boolean hasUnpublishedCTEntries(long modelClassNameId, long modelClassPK, int changeType) {
        int count = this.ctEntryLocalService.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)CTEntryTable.INSTANCE.ctEntryId).from((Table)CTEntryTable.INSTANCE).innerJoinON((Table)CTCollectionTable.INSTANCE, CTCollectionTable.INSTANCE.ctCollectionId.eq((Expression)CTEntryTable.INSTANCE.ctCollectionId)).where(CTCollectionTable.INSTANCE.status.eq((Object)2).and((Expression)CTEntryTable.INSTANCE.modelClassNameId.eq((Object)modelClassNameId)).and((Expression)CTEntryTable.INSTANCE.modelClassPK.eq((Object)modelClassPK)).and((Expression)CTEntryTable.INSTANCE.changeType.eq((Object)changeType))));
        return count != 0;
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public CTEntry updateCTEntry(CTEntry ctEntry) {
        CTCollection ctCollection = this._ctCollectionPersistence.fetchByPrimaryKey(ctEntry.getCtCollectionId());
        if (ctCollection == null) {
            throw new SystemException("No change tracking collection exists for " + String.valueOf(ctEntry));
        }
        int status = ctCollection.getStatus();
        if (status != 2 && status != 1) {
            throw new SystemException("Change tracking collection " + String.valueOf(ctCollection) + " is read only");
        }
        return (CTEntry)this.ctEntryPersistence.update((BaseModel)ctEntry);
    }

    public CTEntry updateModelMvccVersion(long ctEntryId, long modelMvccVersion) {
        CTEntry ctEntry = this.ctEntryPersistence.fetchByPrimaryKey(ctEntryId);
        ctEntry.setModelMvccVersion(modelMvccVersion);
        return (CTEntry)this.ctEntryPersistence.update((BaseModel)ctEntry);
    }
}

