/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.upgrade.v2_13_1;

import com.liferay.change.tracking.configuration.CTSettingsConfiguration;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class CTConflictConfigurationUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME = "com.liferay.change.tracking.configuration.CTConflictConfiguration";
    private final ConfigurationAdmin _configurationAdmin;
    private final ConfigurationProvider _configurationProvider;

    public CTConflictConfigurationUpgradeProcess(ConfigurationAdmin configurationAdmin, ConfigurationProvider configurationProvider) {
        this._configurationAdmin = configurationAdmin;
        this._configurationProvider = configurationProvider;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeCompanyScopedConfigurations();
        this._upgradeSystemConfigurations();
    }

    private Dictionary<String, Object> _mergeProperties(Dictionary<String, Object> ctConflictConfigurationProperties, Dictionary<String, Object> ctSettingsConfigurationProperties) {
        if (ctSettingsConfigurationProperties == null) {
            ctSettingsConfigurationProperties = new HashMapDictionary();
        }
        ctSettingsConfigurationProperties.put("modificationDeletionConflictCheckEnabled", ctConflictConfigurationProperties.get("modificationDeletionConflictCheckEnabled"));
        ctSettingsConfigurationProperties.put("schemaVersionCheckEnabled", ctConflictConfigurationProperties.get("schemaVersionCheckEnabled"));
        return ctSettingsConfigurationProperties;
    }

    private void _upgradeCompanyScopedConfigurations() throws Exception {
        Configuration[] ctConflictConfigurations = this._configurationAdmin.listConfigurations(String.format("(%s=%s.scoped)", "service.factoryPid", _CLASS_NAME));
        if (ctConflictConfigurations == null) {
            return;
        }
        for (Configuration ctConflictConfiguration : ctConflictConfigurations) {
            Dictionary ctConflictConfigurationProperties = ctConflictConfiguration.getProperties();
            if (ctConflictConfigurationProperties == null) continue;
            long companyId = GetterUtil.getLong(ctConflictConfigurationProperties.get(ExtendedObjectClassDefinition.Scope.COMPANY.getPropertyKey()));
            Configuration[] ctSettingsConfigurations = this._configurationAdmin.listConfigurations(String.format("(&(%s=%s.scoped)(%s=%d))", "service.factoryPid", CTSettingsConfiguration.class.getName(), ExtendedObjectClassDefinition.Scope.COMPANY.getPropertyKey(), companyId));
            Dictionary ctSettingsConfigurationProperties = null;
            if (ctSettingsConfigurations != null) {
                Configuration ctSettingsConfiguration = ctSettingsConfigurations[0];
                ctSettingsConfigurationProperties = ctSettingsConfiguration.getProperties();
            }
            this._configurationProvider.saveCompanyConfiguration(CTSettingsConfiguration.class, companyId, this._mergeProperties(ctConflictConfigurationProperties, ctSettingsConfigurationProperties));
            ctConflictConfiguration.delete();
        }
    }

    private void _upgradeSystemConfigurations() throws Exception {
        Configuration[] ctConflictConfigurations = this._configurationAdmin.listConfigurations(String.format("(%s=%s)", "service.pid", _CLASS_NAME));
        if (ctConflictConfigurations == null) {
            return;
        }
        Configuration ctConflictConfiguration = ctConflictConfigurations[0];
        Dictionary ctConflictConfigurationProperties = ctConflictConfiguration.getProperties();
        if (ctConflictConfigurationProperties == null) {
            return;
        }
        Configuration ctSettingsConfiguration = this._configurationAdmin.getConfiguration(CTSettingsConfiguration.class.getName(), "?");
        Dictionary ctSettingsConfigurationProperties = ctSettingsConfiguration.getProperties();
        this._configurationProvider.saveSystemConfiguration(CTSettingsConfiguration.class, this._mergeProperties(ctConflictConfigurationProperties, ctSettingsConfigurationProperties));
        ctConflictConfiguration.delete();
    }
}

