/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import jakarta.portlet.PortletPreferences;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class PortletPreferencesConstraintResolver
implements ConstraintResolver<com.liferay.portal.kernel.model.PortletPreferences> {
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletPreferenceValueLocalService _portletPreferenceValueLocalService;

    public String getConflictDescriptionKey() {
        return "duplicate-widget-preferences";
    }

    public Class<com.liferay.portal.kernel.model.PortletPreferences> getModelClass() {
        return com.liferay.portal.kernel.model.PortletPreferences.class;
    }

    public String getResolutionDescriptionKey() {
        return "duplicate-widget-preferences-were-removed";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, PortletPreferencesConstraintResolver.class);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"ownerId", "ownerType", "plid", "portletId"};
    }

    public void resolveConflict(ConstraintResolverContext<com.liferay.portal.kernel.model.PortletPreferences> constraintResolverContext) throws PortalException {
        com.liferay.portal.kernel.model.PortletPreferences sourcePortletPreferences = (com.liferay.portal.kernel.model.PortletPreferences)constraintResolverContext.getSourceCTModel();
        PortletPreferences jxPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(sourcePortletPreferences);
        this._portletPreferencesLocalService.deletePortletPreferences(sourcePortletPreferences);
        CTPersistence ctPersistence = this._portletPreferencesLocalService.getCTPersistence();
        ctPersistence.flush();
        com.liferay.portal.kernel.model.PortletPreferences targetPortletPreferences = (com.liferay.portal.kernel.model.PortletPreferences)constraintResolverContext.getTargetCTModel();
        this._portletPreferencesLocalService.updatePreferences(targetPortletPreferences.getOwnerId(), targetPortletPreferences.getOwnerType(), targetPortletPreferences.getPlid(), targetPortletPreferences.getPortletId(), jxPortletPreferences);
    }
}

