/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.spi.listener;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.change.tracking.spi.listener.CTEventListener;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTEventListener.class})
public class CTPreferencesEventListener
implements CTEventListener {
    private static final Log _log = LogFactoryUtil.getLog(CTPreferencesEventListener.class);
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;

    public void onAfterPublish(long ctCollectionId) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-39203")) {
            return;
        }
        this._ctPreferencesLocalService.resetCTPreferences(ctCollectionId);
        if (!_log.isInfoEnabled()) {
            return;
        }
        CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
        if (ctCollection == null) {
            return;
        }
        _log.info((Object)("Publication " + ctCollection.getName() + " was published. Production is live."));
    }
}

