/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.security.permission.resource;

import com.liferay.change.tracking.model.CTRemote;
import com.liferay.change.tracking.service.CTRemoteLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTRemote"}, service={ModelResourcePermission.class})
public class CTRemoteModelResourcePermission
implements ModelResourcePermission<CTRemote> {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTRemoteLocalService _ctRemoteLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(resource.name=com.liferay.change.tracking)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, CTRemote ctRemote, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ctRemote, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CTRemote.class.getName(), ctRemote.getCtRemoteId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long ctRemoteId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ctRemoteId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CTRemote.class.getName(), ctRemoteId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CTRemote ctRemote, String actionId) {
        if (permissionChecker.hasOwnerPermission(ctRemote.getCompanyId(), CTRemote.class.getName(), ctRemote.getCtRemoteId(), ctRemote.getUserId(), actionId)) {
            return true;
        }
        Group group = this._groupLocalService.fetchGroup(ctRemote.getCompanyId(), this._classNameLocalService.getClassNameId(CTRemote.class), ctRemote.getCtRemoteId());
        return permissionChecker.hasPermission(group, CTRemote.class.getName(), ctRemote.getCtRemoteId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long ctRemoteId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._ctRemoteLocalService.getCTRemote(ctRemoteId), actionId);
    }

    public String getModelName() {
        return CTRemote.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

