/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.search.spi.model.index.contributor;

import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;

public class CTEntryModelIndexerWriterContributor
implements ModelIndexerWriterContributor<CTEntry> {
    private static final Log _log = LogFactoryUtil.getLog(CTEntryModelIndexerWriterContributor.class);
    private final CTEntryLocalService _ctEntryLocalService;
    private final DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;

    public CTEntryModelIndexerWriterContributor(CTEntryLocalService ctEntryLocalService, DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory) {
        this._ctEntryLocalService = ctEntryLocalService;
        this._dynamicQueryBatchIndexingActionableFactory = dynamicQueryBatchIndexingActionableFactory;
    }

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setPerformActionMethod(ctEntry -> batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)ctEntry)}));
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._ctEntryLocalService.getIndexableActionableDynamicQuery();
        if (!CTCollectionThreadLocal.isProductionMode()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Restricting indexable results of ", CTEntry.class.getName(), " because this can only be ", "performed in production mode"}));
            }
            indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"ctCollectionId", (Object)-1L)));
        }
        return this._dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(indexableActionableDynamicQuery);
    }

    public long getCompanyId(CTEntry ctEntry) {
        return ctEntry.getCompanyId();
    }
}

