/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.model.listener;

import com.liferay.change.tracking.internal.util.CTSchemaVersionHelper;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.version.Version;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ReleaseModelListener
extends BaseModelListener<Release> {
    @Reference
    private CTSchemaVersionHelper _ctSchemaVersionHelper;
    @Reference(target="(module.service.lifecycle=portlets.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;

    public void onAfterCreate(Release release) {
        if (!Objects.equals(release.getSchemaVersion(), "0.0.0")) {
            this._ctSchemaVersionHelper.expireCTCollections();
        }
    }

    public void onAfterRemove(Release release) {
        this._ctSchemaVersionHelper.expireCTCollections();
    }

    public void onAfterUpdate(Release originalRelease, Release release) {
        if (!Objects.equals(originalRelease.getSchemaVersion(), release.getSchemaVersion())) {
            Version version1 = Version.parseVersion((String)originalRelease.getSchemaVersion());
            Version version2 = Version.parseVersion((String)release.getSchemaVersion());
            if (version1.getMajor() != version2.getMajor() || version1.getMinor() != version2.getMinor()) {
                this._ctSchemaVersionHelper.expireCTCollections();
            }
        }
    }
}

