/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.model.listener;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.change.tracking.service.CTProcessLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.TicketLocalService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CTCollectionModelListener
extends BaseModelListener<CTCollection> {
    private static final Log _log = LogFactoryUtil.getLog((String)CTCollectionModelListener.class.getName());
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;
    @Reference
    private CTProcessLocalService _ctProcessLocalService;
    @Reference(target="(indexer.class.name=com.liferay.change.tracking.model.CTEntry)")
    private Indexer<CTEntry> _indexer;
    @Reference
    private TicketLocalService _ticketLocalService;

    public void onAfterRemove(CTCollection ctCollection) {
        this._ctPreferencesLocalService.resetCTPreferences(ctCollection.getCtCollectionId());
        List ctProcesses = this._ctProcessLocalService.getCTProcesses(ctCollection.getCtCollectionId());
        for (CTProcess ctProcess : ctProcesses) {
            try {
                this._ctProcessLocalService.deleteCTProcess(ctProcess);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)portalException);
            }
        }
        this._deleteTickets(ctCollection);
    }

    public void onAfterUpdate(CTCollection originalCTCollection, CTCollection ctCollection) throws ModelListenerException {
        if (!Objects.equals(originalCTCollection.getName(), ctCollection.getName())) {
            try {
                this._indexer.reindex((Collection)this._ctEntryLocalService.getCTCollectionCTEntries(ctCollection.getCtCollectionId(), -1, -1, null));
            }
            catch (SearchException searchException) {
                throw new ModelListenerException((Throwable)searchException);
            }
        }
        if (originalCTCollection.getStatus() != ctCollection.getStatus() && ctCollection.getStatus() == 3) {
            this._ctPreferencesLocalService.resetCTPreferences(ctCollection.getCtCollectionId());
        }
        if (ctCollection.isShareable() || ctCollection.isShareable() == originalCTCollection.isShareable()) {
            return;
        }
        this._deleteTickets(ctCollection);
    }

    private void _deleteTickets(CTCollection ctCollection) {
        for (Ticket ticket : this._ticketLocalService.getTickets(ctCollection.getCompanyId(), CTCollection.class.getName(), ctCollection.getCtCollectionId(), 5)) {
            this._ticketLocalService.deleteTicket(ticket);
        }
    }
}

