/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.configuration.persistence.listener;

import com.liferay.change.tracking.configuration.CTSettingsConfiguration;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Dictionary;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.configuration.CTSettingsConfiguration"}, service={ConfigurationModelListener.class})
public class CTSettingsConfigurationModelListener
implements ConfigurationModelListener {
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void onAfterSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        try {
            this._onAfterSave(properties);
        }
        catch (PortalException portalException) {
            throw new ConfigurationModelListenerException((Exception)((Object)portalException), CTSettingsConfiguration.class, this.getClass(), properties);
        }
    }

    private void _onAfterSave(Dictionary<String, Object> properties) throws PortalException {
        long companyId = GetterUtil.getLong((Object)properties.get("companyId"));
        if (companyId == 0L) {
            return;
        }
        Object[] defaultOwnerActionIds = GetterUtil.getStringValues((Object)properties.get("defaultOwnerActionIds"));
        if (ArrayUtil.isEmpty((Object[])defaultOwnerActionIds)) {
            return;
        }
        Role role = this._roleLocalService.getRole(companyId, "Owner");
        List ctCollections = this._ctCollectionLocalService.getCTCollections(companyId, 2, -1, -1, null);
        for (CTCollection ctCollection : ctCollections) {
            this._resourcePermissionLocalService.setResourcePermissions(companyId, CTCollection.class.getName(), 4, String.valueOf(ctCollection.getCtCollectionId()), role.getRoleId(), (String[])defaultOwnerActionIds);
        }
    }
}

