/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.background.task;

import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.exception.CTPublishConflictException;
import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.internal.background.task.CTServicePublisher;
import com.liferay.change.tracking.internal.background.task.display.CTPublishBackgroundTaskDisplay;
import com.liferay.change.tracking.internal.helper.CTTableMapperHelper;
import com.liferay.change.tracking.internal.helper.CTUserNotificationHelper;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.service.CTSchemaVersionLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"background.task.executor.class.name=com.liferay.change.tracking.internal.background.task.CTPublishBackgroundTaskExecutor"}, service={AopService.class})
public class CTPublishBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor
implements AopService {
    private static final Log _log = LogFactoryUtil.getLog(CTPublishBackgroundTaskExecutor.class);
    private BackgroundTaskExecutor _backgroundTaskExecutor;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTSchemaVersionLocalService _ctSchemaVersionLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private CTUserNotificationHelper _ctUserNotificationHelper;
    @Reference
    private MultiVMPool _multiVMPool;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CTPublishBackgroundTaskExecutor() {
        this.setIsolationLevel(2);
    }

    public BackgroundTaskExecutor clone() {
        return this._backgroundTaskExecutor;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long ctCollectionId = GetterUtil.getLong(taskContextMap.get("ctCollectionId"));
        CTCollection ctCollection = this._ctCollectionLocalService.getCTCollection(ctCollectionId);
        if (!this._ctSchemaVersionLocalService.isLatestCTSchemaVersion(ctCollection.getSchemaVersionId())) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Unable to publish ", ctCollection.getName(), " because it is out of date with the current release"}));
        }
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);){
            this._ctServiceRegistry.onBeforePublish(ctCollectionId);
        }
        Map conflictInfosMap = this._ctCollectionLocalService.checkConflicts(ctCollection);
        if (!conflictInfosMap.isEmpty()) {
            ArrayList<ConflictInfo> unresolvedConflictInfos = new ArrayList<ConflictInfo>();
            for (Map.Entry entry : conflictInfosMap.entrySet()) {
                for (ConflictInfo conflictInfo : (List)entry.getValue()) {
                    if (conflictInfo.isResolved()) continue;
                    unresolvedConflictInfos.add(conflictInfo);
                }
            }
            if (!unresolvedConflictInfos.isEmpty()) {
                throw new CTPublishConflictException(StringBundler.concat((Object[])new Object[]{"Unable to publish ", ctCollection.getName(), " because of unresolved conflicts: ", unresolvedConflictInfos}));
            }
        }
        HashMap<Long, CTServicePublisher> ctServicePublishers = new HashMap<Long, CTServicePublisher>();
        List ctEntries = this._ctEntryLocalService.getCTCollectionCTEntries(ctCollectionId);
        for (CTEntry ctEntry : ctEntries) {
            CTServicePublisher ctServicePublisher = ctServicePublishers.computeIfAbsent(ctEntry.getModelClassNameId(), modelClassNameId -> {
                CTService<?> ctService = this._ctServiceRegistry.getCTService((long)modelClassNameId);
                if (ctService != null) {
                    return new CTServicePublisher(this._ctEntryLocalService, ctService, (long)modelClassNameId, ctCollectionId, 0L);
                }
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to publish ", ctCollection.getName(), " because service for ", modelClassNameId, " is missing"}));
            });
            ctServicePublisher.addCTEntry(ctEntry);
        }
        for (CTServicePublisher ctServicePublisher : ctServicePublishers.values()) {
            ctServicePublisher.publish();
        }
        for (CTTableMapperHelper ctTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
            ctTableMapperHelper.publish(ctCollectionId, this._multiVMPool.getPortalCacheManager());
        }
        Date date = new Date();
        ctCollection.setModifiedDate(date);
        ctCollection.setStatus(0);
        ctCollection.setStatusByUserId(backgroundTask.getUserId());
        ctCollection.setStatusDate(date);
        this._ctCollectionLocalService.updateCTCollection(ctCollection);
        this._ctServiceRegistry.onAfterPublish(ctCollectionId);
        return BackgroundTaskResult.SUCCESS;
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{BackgroundTaskExecutor.class};
    }

    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return new CTPublishBackgroundTaskDisplay(backgroundTask);
    }

    public String handleException(BackgroundTask backgroundTask, Exception exception) {
        block3: {
            boolean showConflicts = false;
            if (exception instanceof CTPublishConflictException) {
                showConflicts = true;
            }
            long ctCollectionId = MapUtil.getLong((Map)backgroundTask.getTaskContextMap(), (String)"ctCollectionId");
            try {
                CTCollection ctCollection = this._ctCollectionLocalService.getCTCollection(ctCollectionId);
                this._ctUserNotificationHelper.sendUserNotificationEvents(ctCollection, JSONUtil.put((String)"backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId()).put("ctCollectionId", ctCollectionId).put("ctCollectionName", HtmlUtil.escape((String)ctCollection.getName())).put("notificationType", 2).put("showConflicts", showConflicts), this._getPublicationRolesUserIds(ctCollection, showConflicts));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)portalException);
            }
        }
        return super.handleException(backgroundTask, exception);
    }

    public void setAopProxy(Object aopProxy) {
        this._backgroundTaskExecutor = (BackgroundTaskExecutor)aopProxy;
    }

    private long[] _getPublicationRolesUserIds(CTCollection ctCollection, boolean showConflicts) {
        Set userIds = SetUtil.fromArray((long[])this._ctUserNotificationHelper.getPublicationRoleUserIds(ctCollection, true, "com_liferay_change_tracking_web_portlet_PublicationsPortlet.admin", "com_liferay_change_tracking_web_portlet_PublicationsPortlet.editor", "com_liferay_change_tracking_web_portlet_PublicationsPortlet.publisher"));
        if (!showConflicts) {
            Role role = this._roleLocalService.fetchRole(ctCollection.getCompanyId(), "Administrator");
            for (long userId : this._userLocalService.getRoleUserIds(role.getRoleId())) {
                userIds.add(userId);
            }
        }
        return ArrayUtil.toLongArray((Collection)userIds);
    }
}

