/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal;

import com.liferay.change.tracking.model.CTPreferences;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionIdSupplier;
import com.liferay.portal.kernel.change.tracking.CTCollectionPreviewThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTCollectionIdSupplier.class})
public class CTCollectionIdSupplierImpl
implements CTCollectionIdSupplier {
    private static final Log _log = LogFactoryUtil.getLog(CTCollectionIdSupplierImpl.class);
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public long getCTCollectionId() {
        CTPreferences ctPreferences;
        block20: {
            long ctCollectionId = CTCollectionPreviewThreadLocal.getCTCollectionId();
            if (ctCollectionId > -1L) {
                return ctCollectionId;
            }
            long companyId = CompanyThreadLocal.getCompanyId();
            long userId = PrincipalThreadLocal.getUserId();
            if (companyId == 0L && userId == 0L) {
                return 0L;
            }
            ctPreferences = null;
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                block21: {
                    ctPreferences = this._ctPreferencesLocalService.fetchCTPreferences(companyId, userId);
                    if (ctPreferences != null && ctPreferences.getCtCollectionId() != 0L) break block20;
                    if (!FeatureFlagManagerUtil.isEnabled((long)companyId, (String)"LPD-39203")) {
                        long l = 0L;
                        return l;
                    }
                    try {
                        userId = this._userLocalService.getGuestUserId(companyId);
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) break block21;
                        _log.warn((Throwable)portalException);
                    }
                }
                ctPreferences = this._ctPreferencesLocalService.getCTPreferences(companyId, userId);
            }
        }
        return ctPreferences.getCtCollectionId();
    }
}

