/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.internal.background.task.CTPublishBackgroundTaskExecutor;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.change.tracking.service.base.CTProcessLocalServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTCollectionPersistence;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTProcess"}, service={AopService.class})
public class CTProcessLocalServiceImpl
extends CTProcessLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CTProcessLocalServiceImpl.class);
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CTCollectionPersistence _ctCollectionPersistence;
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CTProcess addCTProcess(long userId, long ctCollectionId) throws PortalException {
        return this.addCTProcess(userId, ctCollectionId, 0L, null);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CTProcess addCTProcess(long userId, long fromCTCollectionId, long toCTCollectionId, long[] ctEntryIds) throws PortalException {
        CTCollection ctCollection = this._ctCollectionPersistence.findByPrimaryKey(fromCTCollectionId);
        if (ctCollection.getStatus() == 0) {
            throw new IllegalStateException("Change tracking collection is already published " + ctCollection);
        }
        if (ctCollection.isEmpty()) {
            throw new IllegalStateException("Change tracking collection is empty " + ctCollection);
        }
        if (toCTCollectionId == 0L) {
            ctCollection.setStatus(1);
            ctCollection = (CTCollection)this._ctCollectionPersistence.update((BaseModel)ctCollection);
            this._ctPreferencesLocalService.resetCTPreferences(ctCollection.getCtCollectionId());
        }
        long ctProcessId = this.counterLocalService.increment(CTProcess.class.getName());
        CTProcess ctProcess = this.ctProcessPersistence.create(ctProcessId);
        ctProcess.setCompanyId(ctCollection.getCompanyId());
        ctProcess.setUserId(userId);
        ctProcess.setCreateDate(new Date());
        ctProcess.setCtCollectionId(fromCTCollectionId);
        if (toCTCollectionId != 0L) {
            ctProcess.setType(1);
        }
        HashMap taskContextMap = HashMapBuilder.put((Object)"ctEntryIds", (Object)ctEntryIds).put((Object)"ctProcessId", (Object)ctProcessId).put((Object)"fromCTCollectionId", (Object)fromCTCollectionId).put((Object)"toCTCollectionId", (Object)toCTCollectionId).build();
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
            Company company = this._companyLocalService.getCompany(ctCollection.getCompanyId());
            String name = String.valueOf(fromCTCollectionId);
            if (toCTCollectionId != 0L) {
                name = String.valueOf(fromCTCollectionId) + "_" + String.valueOf(toCTCollectionId);
            }
            BackgroundTask backgroundTask = this._backgroundTaskLocalService.addBackgroundTask(userId, company.getGroupId(), name, null, CTPublishBackgroundTaskExecutor.class, (Map)taskContextMap, null);
            ctProcess.setBackgroundTaskId(backgroundTask.getBackgroundTaskId());
        }
        return (CTProcess)this.ctProcessPersistence.update((BaseModel)ctProcess);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CTProcess deleteCTProcess(CTProcess ctProcess) {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchBackgroundTask(ctProcess.getBackgroundTaskId());
        if (backgroundTask != null) {
            try {
                this._backgroundTaskLocalService.deleteBackgroundTask(backgroundTask);
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        return (CTProcess)this.ctProcessPersistence.remove((BaseModel)ctProcess);
    }

    public CTProcess fetchLatestCTProcess(long companyId) {
        return this.ctProcessPersistence.fetchByCompanyId_First(companyId, null);
    }

    public List<CTProcess> getCTProcesses(long ctCollectionId) {
        return this.ctProcessPersistence.findByCtCollectionId(ctCollectionId);
    }
}

