/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.security.auto.login;

import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AutoLogin.class})
public class CTOnDemandUserAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(CTOnDemandUserAutoLogin.class);
    @Reference
    private TicketLocalService _ticketLocalService;
    @Reference
    private UserLocalService _userLocalService;

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-187436")) {
            return null;
        }
        String portletId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id");
        if (!Objects.equals(portletId, "com_liferay_change_tracking_web_portlet_PublicationsPortlet")) {
            return null;
        }
        Ticket ticket = this._getTicket(httpServletRequest);
        if (ticket == null) {
            return null;
        }
        User user = this._userLocalService.getUser(Long.valueOf(ticket.getExtraInfo()).longValue());
        if (user != null && !user.isOnDemandUser()) {
            return null;
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }

    private Ticket _getTicket(HttpServletRequest httpServletRequest) {
        block5: {
            String ticketKey = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"ticketKey");
            if (Validator.isNull((String)ticketKey)) {
                return null;
            }
            try {
                Ticket ticket = this._ticketLocalService.fetchTicket(ticketKey);
                if (ticket == null || ticket.getType() != 5) {
                    return null;
                }
                if (!ticket.isExpired()) {
                    return ticket;
                }
                this._ticketLocalService.deleteTicket(ticket);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        return null;
    }
}

