/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.search.spi.model.permission;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.RoleModel;
import com.liferay.portal.kernel.model.UserGroupRoleTable;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.spi.model.permission.contributor.SearchPermissionFilterContributor;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchPermissionFilterContributor.class})
public class CTCollectionSearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    private static final Log _log = LogFactoryUtil.getLog(CTCollectionSearchPermissionFilterContributor.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference(target="(model.class.name=com.liferay.change.tracking.model.CTCollection)")
    private ModelResourcePermission<CTCollection> _ctCollectionModelResourcePermission;
    @Reference
    private RoleLocalService _roleLocalService;

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        if (!className.equals(CTCollection.class.getName())) {
            return;
        }
        try {
            this._addCTCollectionIdsFilter(booleanFilter, companyId, userId, permissionChecker);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    private void _addCTCollectionIdsFilter(BooleanFilter booleanFilter, long companyId, long userId, PermissionChecker permissionChecker) throws PortalException {
        List ctCollectionIds = (List)this._ctCollectionLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{CTCollectionTable.INSTANCE.ctCollectionId}).from((Table)CTCollectionTable.INSTANCE).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(CTCollection.class)).and((Expression)GroupTable.INSTANCE.classPK.eq((Expression)CTCollectionTable.INSTANCE.ctCollectionId))).innerJoinON((Table)UserGroupRoleTable.INSTANCE, UserGroupRoleTable.INSTANCE.groupId.eq((Expression)GroupTable.INSTANCE.groupId).and((Expression)UserGroupRoleTable.INSTANCE.roleId.in(TransformUtil.transformToArray((Collection)this._roleLocalService.getRoles(companyId, new int[]{7}), RoleModel::getRoleId, Long.class))).and((Expression)UserGroupRoleTable.INSTANCE.userId.eq((Object)userId))));
        ctCollectionIds = ListUtil.filter((List)ctCollectionIds, ctCollectionId -> {
            try {
                return this._ctCollectionModelResourcePermission.contains(permissionChecker, ctCollectionId.longValue(), "VIEW");
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)portalException);
                }
                return false;
            }
        });
        TermsFilter classPksFilter = new TermsFilter("entryClassPK");
        if (!ctCollectionIds.isEmpty()) {
            classPksFilter.addValues(ArrayUtil.toStringArray((Collection)ctCollectionIds));
        }
        if (!classPksFilter.isEmpty()) {
            booleanFilter.add((Filter)classPksFilter, BooleanClauseOccur.SHOULD);
        }
    }
}

