/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.search;

import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.spi.exception.CTEventException;
import com.liferay.change.tracking.spi.listener.CTEventListener;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.search.model.uid.UIDFactory;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTEventListener.class})
public class CTSearchEventListener
implements CTEventListener {
    private static final Log _log = LogFactoryUtil.getLog(CTSearchEventListener.class);
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private UIDFactory _uidFactory;

    public void onAfterCopy(long sourceCTCollectionId, long targetCTCollectionId) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)targetCTCollectionId);){
                for (Map.Entry<CTService<?>, List<CTEntry>> ctEntryEntry : this._getCTEntryEntries(targetCTCollectionId)) {
                    this._reindex(ctEntryEntry.getKey(), ctEntryEntry.getValue());
                }
            }
            return null;
        });
    }

    public void onAfterPublish(long ctCollectionId) {
        CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
        if (ctCollection == null) {
            return;
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                for (Map.Entry<CTService<?>, List<CTEntry>> ctEntryEntry : this._getCTEntryEntries(ctCollectionId)) {
                    CTService<?> ctService = ctEntryEntry.getKey();
                    Indexer indexer = this._indexerRegistry.getIndexer(ctService.getModelClass());
                    if (indexer == null) continue;
                    List<CTEntry> ctEntries = ctEntryEntry.getValue();
                    ArrayList<String> uids = new ArrayList<String>(ctEntries.size());
                    for (CTEntry ctEntry : ctEntries) {
                        uids.add(this._uidFactory.getUID(indexer.getClassName(), (Serializable)Long.valueOf(ctEntry.getModelClassPK()), 0L));
                    }
                    this._indexWriterHelper.deleteDocuments(ctCollection.getCompanyId(), uids, indexer.isCommitImmediately());
                    this._reindex(ctEntryEntry.getKey(), ctEntryEntry.getValue());
                }
            }
            return null;
        });
    }

    public void onBeforeRemove(long ctCollectionId) throws CTEventException {
        CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
        if (ctCollection == null || ctCollection.getStatus() == 0) {
            return;
        }
        for (Map.Entry<CTService<?>, List<CTEntry>> ctEntryEntry : this._getCTEntryEntries(ctCollectionId)) {
            CTService<?> ctService = ctEntryEntry.getKey();
            Indexer indexer = this._indexerRegistry.getIndexer(ctService.getModelClass());
            if (indexer == null) continue;
            List<CTEntry> ctEntries = ctEntryEntry.getValue();
            ArrayList<String> uids = new ArrayList<String>(ctEntries.size());
            for (CTEntry ctEntry : ctEntries) {
                if (ctEntry.getChangeType() == 1) continue;
                uids.add(this._uidFactory.getUID(indexer.getClassName(), (Serializable)Long.valueOf(ctEntry.getModelClassPK()), ctEntry.getCtCollectionId()));
            }
            try {
                this._indexWriterHelper.deleteDocuments(ctCollection.getCompanyId(), uids, indexer.isCommitImmediately());
            }
            catch (SearchException searchException) {
                throw new CTEventException((Throwable)searchException);
            }
        }
    }

    private Collection<Map.Entry<CTService<?>, List<CTEntry>>> _getCTEntryEntries(long ctCollectionId) {
        HashMap<Long, Map.Entry> ctEntryMap = new HashMap<Long, Map.Entry>();
        for (CTEntry ctEntry : this._ctEntryLocalService.getCTCollectionCTEntries(ctCollectionId)) {
            Map.Entry entry = ctEntryMap.computeIfAbsent(ctEntry.getModelClassNameId(), classNameId -> {
                CTService<?> ctService = this._ctServiceRegistry.getCTService((long)classNameId);
                if (ctService == null) {
                    return null;
                }
                return new AbstractMap.SimpleImmutableEntry(ctService, new ArrayList());
            });
            if (entry == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No CT service found for class name ID " + ctEntry.getModelClassNameId()));
                continue;
            }
            List ctEntries = (List)entry.getValue();
            ctEntries.add(ctEntry);
        }
        return ctEntryMap.values();
    }

    private <T extends CTModel<T>> void _reindex(CTService<T> ctService, List<CTEntry> ctEntries) throws SearchException {
        Indexer indexer = this._indexerRegistry.getIndexer(ctService.getModelClass());
        if (indexer == null) {
            return;
        }
        HashSet<Long> primaryKeys = new HashSet<Long>();
        for (CTEntry ctEntry : ctEntries) {
            if (ctEntry.getChangeType() == 1) continue;
            primaryKeys.add(ctEntry.getModelClassPK());
        }
        if (primaryKeys.isEmpty()) {
            return;
        }
        ctService.updateWithUnsafeFunction(ctPersistence -> {
            Map models = ctPersistence.fetchByPrimaryKeys(primaryKeys);
            indexer.reindex(models.values());
            return null;
        });
    }
}

