/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.model.listener;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.service.TicketLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CTCollectionModelListener
extends BaseModelListener<CTCollection> {
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;
    @Reference
    private TicketLocalService _ticketLocalService;

    public void onAfterRemove(CTCollection ctCollection) {
        this._ctPreferencesLocalService.resetCTPreferences(ctCollection.getCtCollectionId());
        this._deleteTickets(ctCollection);
    }

    public void onAfterUpdate(CTCollection originalCTCollection, CTCollection ctCollection) throws ModelListenerException {
        if (originalCTCollection.getStatus() != ctCollection.getStatus() && ctCollection.getStatus() == 3) {
            this._ctPreferencesLocalService.resetCTPreferences(ctCollection.getCtCollectionId());
        }
        if (ctCollection.isShareable() || ctCollection.isShareable() == originalCTCollection.isShareable()) {
            return;
        }
        this._deleteTickets(ctCollection);
    }

    private void _deleteTickets(CTCollection ctCollection) {
        for (Ticket ticket : this._ticketLocalService.getTickets(ctCollection.getCompanyId(), CTCollection.class.getName(), ctCollection.getCtCollectionId(), 5)) {
            this._ticketLocalService.deleteTicket(ticket);
        }
    }
}

